Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/plugins/page-structure/components/StructureTreeNode", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../app/components/CollectionItemContext', '../../../app/components/Controls', '../../../app/components/layout-data-items/Collection', '../../../app/config/constants/itemActivationOrigins', '../../../app/store/index', '../../../app/thunks/deleteItem'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = StructureTreeNode;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _CollectionItemContext = require("../../../app/components/CollectionItemContext");

  var _Controls = require("../../../app/components/Controls");

  var _Collection = require("../../../app/components/layout-data-items/Collection");

  var _itemActivationOrigins = require("../../../app/config/constants/itemActivationOrigins");

  var _index = require("../../../app/store/index");

  var _deleteItem = _interopRequireDefault(require("../../../app/thunks/deleteItem"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var nodeIsHovered = function nodeIsHovered(nodeId, hoveredItemId) {
    return nodeId === (0, _Collection.fromControlsId)(hoveredItemId);
  };

  var nodeIsSelected = function nodeIsSelected(nodeId, activeItemId) {
    return nodeId === (0, _Collection.fromControlsId)(activeItemId);
  };

  function StructureTreeNode(_ref) {
    var node = _ref.node;
    var hoverItem = (0, _Controls.useHoverItem)();
    var activeItemId = (0, _Controls.useActiveItemId)();
    var hoveredItemId = (0, _Controls.useHoveredItemId)();
    var selectItem = (0, _Controls.useSelectItem)();
    var toControlsId = (0, _CollectionItemContext.useToControlsId)();
    return _react["default"].createElement("div", {
      "aria-selected": node.activable && nodeIsSelected(node.id, activeItemId),
      className: (0, _classnames["default"])('page-editor__page-structure__tree-node', {
        'page-editor__page-structure__tree-node--active': node.activable && nodeIsSelected(node.id, activeItemId),
        'page-editor__page-structure__tree-node--hovered': nodeIsHovered(node.id, hoveredItemId)
      }),
      onMouseLeave: function onMouseLeave(event) {
        event.stopPropagation();

        if (nodeIsHovered(node.id, hoveredItemId)) {
          hoverItem(null);
        }
      },
      onMouseOver: function onMouseOver(event) {
        event.stopPropagation();
        hoverItem(node.id);
      }
    }, _react["default"].createElement(_button["default"], {
      "aria-label": Liferay.Util.sub(Liferay.Language.get('select-x'), [node.name]),
      className: "page-editor__page-structure__tree-node__mask",
      disabled: node.disabled,
      displayType: "unstyled",
      onClick: function onClick(event) {
        event.stopPropagation();
        event.target.focus();
        selectItem(toControlsId(node.id), {
          itemType: node.type,
          origin: _itemActivationOrigins.ITEM_ACTIVATION_ORIGINS.structureTree
        });
      },
      onDoubleClick: function onDoubleClick(event) {
        return event.stopPropagation();
      }
    }), _react["default"].createElement(NameLabel, {
      activable: node.activable,
      disabled: node.disabled,
      id: node.id,
      name: node.name
    }), node.removable && _react["default"].createElement(RemoveButton, {
      node: node,
      visible: nodeIsHovered(node.id, hoveredItemId) || nodeIsSelected(node.id, activeItemId)
    }));
  }

  var NameLabel = function NameLabel(_ref2) {
    var activable = _ref2.activable,
        disabled = _ref2.disabled,
        id = _ref2.id,
        name = _ref2.name;
    var activeItemId = (0, _Controls.useActiveItemId)();
    return _react["default"].createElement("div", {
      className: (0, _classnames["default"])('page-editor__page-structure__tree-node__name', {
        'page-editor__page-structure__tree-node__name--active': activable && nodeIsSelected(id, activeItemId),
        'page-editor__page-structure__tree-node__name--disabled': disabled
      })
    }, name || Liferay.Language.get('element'));
  };

  var RemoveButton = function RemoveButton(_ref3) {
    var node = _ref3.node,
        visible = _ref3.visible;
    var dispatch = (0, _index.useDispatch)();
    var store = (0, _index.useSelector)(function (state) {
      return state;
    });
    return _react["default"].createElement(_button["default"], {
      "aria-label": Liferay.Util.sub(Liferay.Language.get('remove-x'), [node.name]),
      className: (0, _classnames["default"])('page-editor__page-structure__tree-node__remove-button', {
        'page-editor__page-structure__tree-node__remove-button--visible': visible
      }),
      displayType: "unstyled",
      onClick: function onClick(event) {
        event.stopPropagation();
        dispatch((0, _deleteItem["default"])({
          itemId: node.id,
          store: store
        }));
      }
    }, _react["default"].createElement(_icon["default"], {
      symbol: "times-circle"
    }));
  };
  //# sourceMappingURL=StructureTreeNode.js.map
});
//# sourceMappingURL=StructureTreeNode.js.map