Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/plugins/page-structure/components/PageStructureSidebar", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', 'frontend-js-components-web', 'frontend-js-react-web$react', '../../../app/components/Controls', '../../../app/components/layout-data-items/hasDropZoneChild', '../../../app/config/constants/editableFragmentEntryProcessor', '../../../app/config/constants/itemTypes', '../../../app/config/constants/layoutDataItemTypeLabels', '../../../app/config/constants/layoutDataItemTypes', '../../../app/config/constants/pageTypes', '../../../app/config/index', '../../../app/store/index', '../../../common/components/SidebarPanelHeader', './StructureTreeNode'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = PageStructureSidebar;

  var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

  var _frontendJsComponentsWeb = require("frontend-js-components-web");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _Controls = require("../../../app/components/Controls");

  var _hasDropZoneChild = _interopRequireDefault(require("../../../app/components/layout-data-items/hasDropZoneChild"));

  var _editableFragmentEntryProcessor = require("../../../app/config/constants/editableFragmentEntryProcessor");

  var _itemTypes = require("../../../app/config/constants/itemTypes");

  var _layoutDataItemTypeLabels = require("../../../app/config/constants/layoutDataItemTypeLabels");

  var _layoutDataItemTypes = require("../../../app/config/constants/layoutDataItemTypes");

  var _pageTypes = require("../../../app/config/constants/pageTypes");

  var _index = require("../../../app/config/index");

  var _index2 = require("../../../app/store/index");

  var _SidebarPanelHeader = _interopRequireDefault(require("../../../common/components/SidebarPanelHeader"));

  var _StructureTreeNode = _interopRequireDefault(require("./StructureTreeNode"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function PageStructureSidebar() {
    var activeItemId = (0, _Controls.useActiveItemId)();
    var layoutData = (0, _index2.useSelector)(function (state) {
      return state.layoutData;
    });
    var masterLayoutData = (0, _index2.useSelector)(function (state) {
      return state.masterLayoutData;
    });
    var state = (0, _index2.useSelector)(function (state) {
      return state;
    });
    var isMasterPage = _index.config.pageType === _pageTypes.PAGE_TYPES.master;
    var data = masterLayoutData || layoutData;
    var nodes = (0, _react.useMemo)(function () {
      return visit(data.items[data.rootItems.main], data.items, {
        activeItemId: activeItemId,
        isMasterPage: isMasterPage,
        state: state
      }).children;
    }, [data, activeItemId, isMasterPage, state]);
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_SidebarPanelHeader["default"], null, Liferay.Language.get('page-structure')), _react["default"].createElement("div", {
      className: "page-editor__page-structure px-4"
    }, !nodes.length && _react["default"].createElement(_alert["default"], {
      displayType: "info",
      title: Liferay.Language.get('info')
    }, Liferay.Language.get('there-is-no-content-on-this-page')), _react["default"].createElement(_frontendJsComponentsWeb.Treeview, {
      NodeComponent: _StructureTreeNode["default"],
      nodes: nodes,
      selectedNodeIds: [activeItemId]
    })));
  }

  function isRemovable(item, layoutData) {
    if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone || item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column || item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem) {
      return false;
    }

    return !(0, _hasDropZoneChild["default"])(item, layoutData);
  }

  function getName(item, fragmentEntryLinks) {
    var name;

    if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment) {
      name = fragmentEntryLinks[item.config.fragmentEntryLinkId].name;
    } else if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection) {
      name = _layoutDataItemTypeLabels.LAYOUT_DATA_ITEM_TYPE_LABELS.collection;
    } else if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem) {
      name = _layoutDataItemTypeLabels.LAYOUT_DATA_ITEM_TYPE_LABELS.collectionItem;
    } else if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container) {
      name = _layoutDataItemTypeLabels.LAYOUT_DATA_ITEM_TYPE_LABELS.container;
    } else if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column) {
      name = _layoutDataItemTypeLabels.LAYOUT_DATA_ITEM_TYPE_LABELS.column;
    } else if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone) {
      name = _layoutDataItemTypeLabels.LAYOUT_DATA_ITEM_TYPE_LABELS.dropZone;
    } else if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row) {
      name = _layoutDataItemTypeLabels.LAYOUT_DATA_ITEM_TYPE_LABELS.row;
    }

    return name;
  }

  function visit(item, items, _ref) {
    var activeItemId = _ref.activeItemId,
        isMasterPage = _ref.isMasterPage,
        state = _ref.state;
    var children = [];
    var fragmentEntryLinks = state.fragmentEntryLinks,
        layoutData = state.layoutData,
        masterLayoutData = state.masterLayoutData;
    var itemInMasterLayout = masterLayoutData && Object.keys(masterLayoutData.items).includes(item.itemId);

    if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment) {
      var fragmentEntryLink = fragmentEntryLinks[item.config.fragmentEntryLinkId];
      var editables = fragmentEntryLink.editableValues[_editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR] || {};
      Object.keys(editables).forEach(function (editableId) {
        var childId = "".concat(item.config.fragmentEntryLinkId, "-").concat(editableId);
        children.push({
          activable: true,
          children: [],
          disabled: !isMasterPage && itemInMasterLayout,
          expanded: childId === activeItemId,
          id: childId,
          name: editableId,
          removable: false,
          type: _itemTypes.ITEM_TYPES.editable
        });
      });
      children.push.apply(children, _toConsumableArray(item.children.map(function (childItemId) {
        return _objectSpread({}, visit(items[childItemId], items, {
          activeItemId: activeItemId,
          isMasterPage: isMasterPage,
          state: state
        }), {
          name: Liferay.Language.get('drop-zone'),
          removable: false
        });
      })));
    } else {
      item.children.forEach(function (childId) {
        var childItem = items[childId];

        if (!isMasterPage && childItem.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone) {
          var dropZoneChildren = visit(layoutData.items[layoutData.rootItems.main], layoutData.items, {
            activeItemId: activeItemId,
            isMasterPage: isMasterPage,
            state: state
          }).children;
          children.push.apply(children, _toConsumableArray(dropZoneChildren));
        } else {
          var child = visit(childItem, items, {
            activeItemId: activeItemId,
            isMasterPage: isMasterPage,
            state: state
          });
          children.push(child);
        }
      });
    }

    var node = {
      activable: layoutData.items[item.itemId] && layoutData.items[item.itemId].type !== _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column && layoutData.items[item.itemId].type !== _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem,
      children: children,
      disabled: !isMasterPage && itemInMasterLayout,
      expanded: item.itemId === activeItemId,
      id: item.itemId,
      name: getName(item, fragmentEntryLinks),
      removable: !itemInMasterLayout && isRemovable(item, layoutData),
      type: _itemTypes.ITEM_TYPES.layoutDataItem
    };
    return node;
  }
  //# sourceMappingURL=PageStructureSidebar.js.map
});
//# sourceMappingURL=PageStructureSidebar.js.map