Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/plugins/fragments/components/LayoutElements", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../../../app/components/Controls', '../../../app/store/index', '../../../app/thunks/addItem', '../../../app/utils/useDragAndDrop', '../../../common/components/Collapse'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = LayoutElements;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _Controls = require("../../../app/components/Controls");

  var _index = require("../../../app/store/index");

  var _addItem = _interopRequireDefault(require("../../../app/thunks/addItem"));

  var _useDragAndDrop = require("../../../app/utils/useDragAndDrop");

  var _Collapse = _interopRequireDefault(require("../../../common/components/Collapse"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var layoutElements = [{
    columns: ['12'],
    label: Liferay.Language.get('section'),
    type: 'container'
  }, {
    columns: ['4', '4', '4'],
    label: Liferay.Language.get('row'),
    type: 'row'
  }];

  var LayoutElementCard = function LayoutElementCard(_ref) {
    var label = _ref.label,
        layoutColumns = _ref.layoutColumns,
        type = _ref.type;
    var dispatch = (0, _index.useDispatch)();
    var store = (0, _index.useSelector)(function (state) {
      return state;
    });
    var selectItem = (0, _Controls.useSelectItem)();

    var _useDragSymbol = (0, _useDragAndDrop.useDragSymbol)({
      label: label,
      type: type
    }, function (parentId, position) {
      dispatch((0, _addItem["default"])({
        itemType: type,
        parentItemId: parentId,
        position: position,
        selectItem: selectItem,
        store: store
      }));
    }),
        sourceRef = _useDragSymbol.sourceRef;

    return _react["default"].createElement("button", {
      "aria-label": label,
      className: (0, _classnames["default"])('page-editor__fragments__layout-element-card-preview', 'card', 'card-interactive', 'card-interactive-secondary', 'selector-button'),
      ref: sourceRef,
      type: "button"
    }, _react["default"].createElement("div", {
      className: "card-body px-2 py-3",
      role: "image"
    }, _react["default"].createElement("div", {
      className: "container p-0"
    }, _react["default"].createElement("div", {
      className: "row"
    }, layoutColumns.map(function (column, index) {
      return _react["default"].createElement("div", {
        className: "col col-".concat(column),
        key: "".concat(index, "-").concat(column)
      });
    }))), _react["default"].createElement("div", {
      className: "card-title pt-3 text-truncate"
    }, label)));
  };

  function LayoutElements() {
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_Collapse["default"], {
      label: Liferay.Language.get('layout-elements'),
      open: false
    }, _react["default"].createElement("div", {
      className: "d-flex flex-wrap justify-content-between"
    }, layoutElements.map(function (layoutElement) {
      return _react["default"].createElement(LayoutElementCard, {
        key: layoutElement.columns.join(),
        label: layoutElement.label,
        layoutColumns: layoutElement.columns,
        type: layoutElement.type
      });
    }))));
  }
  //# sourceMappingURL=LayoutElements.js.map
});
//# sourceMappingURL=LayoutElements.js.map