Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/plugins/fragments/components/FragmentCard", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../app/components/Controls', '../../../app/config/constants/layoutDataItemTypes', '../../../app/store/index', '../../../app/thunks/addFragment', '../../../app/utils/useDragAndDrop'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = FragmentCard;

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _Controls = require("../../../app/components/Controls");

  var _layoutDataItemTypes = require("../../../app/config/constants/layoutDataItemTypes");

  var _index = require("../../../app/store/index");

  var _addFragment = _interopRequireDefault(require("../../../app/thunks/addFragment"));

  var _useDragAndDrop = require("../../../app/utils/useDragAndDrop");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var ImagePreview = function ImagePreview(_ref) {
    var imagePreviewURL = _ref.imagePreviewURL;

    if (imagePreviewURL) {
      return _react["default"].createElement("div", {
        className: "page-editor__fragments__fragment-card-preview"
      }, _react["default"].createElement("img", {
        alt: "thumbnail",
        src: imagePreviewURL
      }));
    }

    return _react["default"].createElement("div", {
      className: "page-editor__fragments__fragment-card-no-preview"
    }, _react["default"].createElement(_icon["default"], {
      symbol: "picture"
    }));
  };

  function FragmentCard(_ref2) {
    var fragmentEntryKey = _ref2.fragmentEntryKey,
        groupId = _ref2.groupId,
        imagePreviewURL = _ref2.imagePreviewURL,
        name = _ref2.name,
        type = _ref2.type;
    var dispatch = (0, _index.useDispatch)();
    var store = (0, _index.useSelector)(function (state) {
      return state;
    });
    var selectItem = (0, _Controls.useSelectItem)();

    var _useDragSymbol = (0, _useDragAndDrop.useDragSymbol)({
      label: name,
      type: _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment
    }, function (parentId, position) {
      dispatch((0, _addFragment["default"])({
        fragmentEntryKey: fragmentEntryKey,
        groupId: groupId,
        parentItemId: parentId,
        position: position,
        selectItem: selectItem,
        store: store,
        type: type
      }));
    }),
        sourceRef = _useDragSymbol.sourceRef;

    return _react["default"].createElement("div", {
      className: (0, _classnames["default"])('page-editor__fragments__fragment-card', 'card', 'card-interactive', 'card-interactive-secondary', 'selector-button', 'overflow-hidden'),
      ref: sourceRef
    }, _react["default"].createElement(ImagePreview, {
      imagePreviewURL: imagePreviewURL
    }), _react["default"].createElement("div", {
      className: "card-body"
    }, _react["default"].createElement("div", {
      className: "card-row"
    }, _react["default"].createElement("div", {
      className: "autofit-col autofit-col-expand autofit-row-center"
    }, _react["default"].createElement("div", {
      className: "card-title text-truncate"
    }, name)))));
  }
  //# sourceMappingURL=FragmentCard.js.map
});
//# sourceMappingURL=FragmentCard.js.map