Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/plugins/experience/reducers/utils", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.addExperience = addExperience;
  exports.deleteExperienceById = deleteExperienceById;
  exports.removeLayoutDataItemById = removeLayoutDataItemById;
  exports.selectExperience = selectExperience;
  exports.setExperienceLock = setExperienceLock;
  exports.setExperimentStatus = setExperimentStatus;
  exports.setUsedWidgets = setUsedWidgets;
  exports.storeNewLayoutData = storeNewLayoutData;
  exports.switchLayoutData = switchLayoutData;

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function addExperience(state, experience) {

    return _objectSpread({}, state, {
      availableSegmentsExperiences: _objectSpread({}, state.availableSegmentsExperiences, _defineProperty({}, experience.segmentsExperienceId, experience))
    });
  }
  /**
   * Sets `lockedSegmentsExperience` in the state, depending on the Experience
   * @param {object} state
   * @param {string | null} state.selectedSidebarPanelId
   * @param {object} experience
   * @param {boolean} experience.hasLockedSegmentsExperiment
   * @return {object} nextState
   */

  function setExperienceLock(state, experience) {
    var lockedSegmentsExperience = experience.hasLockedSegmentsExperiment; //TODO selectedSidebarPanelId

    return _objectSpread({}, state, {
      lockedSegmentsExperience: lockedSegmentsExperience
    });
  }
  /**
   * Stores a the layout data of a new experience in layoutDataList
   * @param {object} state
   * @param {Array<{segmentsExperienceId: string}>} state.layoutDataList
   * @param {object} state.layoutData
   * @param {string} state.defaultSegmentsExperienceId
   * @param {string} segmentsExperienceId The segmentsExperience id that owns this LayoutData
   * @param {string} layoutData The new LayoutData to store
   * @returns {object}
   */

  function storeNewLayoutData(state, segmentsExperienceId, layoutData) {
    var nextState = state;
    nextState.layoutDataList.push({
      layoutData: layoutData,
      segmentsExperienceId: segmentsExperienceId
    });
    return nextState;
  }

  function selectExperience(state, experienceId) {
    return _objectSpread({}, state, {
      segmentsExperienceId: experienceId
    });
  }

  function switchLayoutData(state, _ref) {
    var currentExperienceId = _ref.currentExperienceId,
        targetExperienceId = _ref.targetExperienceId;
    var nextState = state;
    var _nextState = nextState,
        prevLayoutData = _nextState.layoutData,
        layoutDataList = _nextState.layoutDataList;
    var layoutDataItem = state.layoutDataList.find(function (layoutDataItem) {
      return layoutDataItem.segmentsExperienceId === targetExperienceId;
    });
    nextState = _objectSpread({}, nextState, {
      layoutData: layoutDataItem.layoutData,
      layoutDataList: layoutDataList.map(function (layoutDataItem) {
        if (currentExperienceId === layoutDataItem.segmentsExperienceId) {
          return _objectSpread({}, layoutDataItem, {
            layoutData: prevLayoutData
          });
        }

        return layoutDataItem;
      })
    });
    return nextState;
  }

  function deleteExperienceById(state, segmentsExperienceId) {
    var experiences = _objectSpread({}, state.availableSegmentsExperiences);

    delete experiences[segmentsExperienceId];
    return _objectSpread({}, state, {
      availableSegmentsExperiences: experiences
    });
  }

  function removeLayoutDataItemById(state, segmentsExperienceId) {
    var layoutDataList = state.layoutDataList;
    var updatedLayoutDataList = layoutDataList.filter(function (layoutDataItem) {
      return layoutDataItem.segmentsExperienceId !== segmentsExperienceId;
    });
    return _objectSpread({}, state, {
      layoutDataList: updatedLayoutDataList
    });
  }
  /**
   * Sets used widgets based on the portletIds array
   * @param {!Array} widgets
   * @param {{!Array} portletIds
   * @return {Array}
   * @review
   */

  function updateUsedWidgets(widgets, portletIds) {
    var filteredWidgets = _toConsumableArray(widgets);

    filteredWidgets.forEach(function (widgetCategory) {
      var _widgetCategory$categ = widgetCategory.categories,
          categories = _widgetCategory$categ === void 0 ? [] : _widgetCategory$categ,
          _widgetCategory$portl = widgetCategory.portlets,
          portlets = _widgetCategory$portl === void 0 ? [] : _widgetCategory$portl;
      widgetCategory.categories = updateUsedWidgets(categories, portletIds);
      widgetCategory.portlets = portlets.map(function (portlet) {
        if (portletIds.indexOf(portlet.portletId) !== -1 && !portlet.instanceable) {
          portlet.used = true;
        } else {
          portlet.used = false;
        }

        return portlet;
      });
    });
    return filteredWidgets;
  }
  /**
   * Attaches to the state a the experiment status of a experience
   */

  function setExperimentStatus(state, experienceId) {
    var selectedExperience = state.availableSegmentsExperiences[experienceId];
    return _objectSpread({}, state, {
      segmentsExperimentStatus: selectedExperience.segmentsExperimentStatus
    });
  }
  /**
   *
   * @param {object} state
   * @param {string} segmentsExperienceId
   * @returns {object}
   */

  function setUsedWidgets(state, _ref2) {
    var portletIds = _ref2.portletIds;
    var updatedWidgets = updateUsedWidgets(state.widgets, portletIds);
    return _objectSpread({}, state, {
      widgets: updatedWidgets
    });
  }
  //# sourceMappingURL=utils.js.map
});
//# sourceMappingURL=utils.js.map