Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/plugins/experience/components/ExperienceModal", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/modal', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../app/config/index', '../../../common/components/Button'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _modal = _interopRequireDefault(require("@frontend-taglib-clay$clayui/modal"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _index = require("../../../app/config/index");

  var _Button = _interopRequireDefault(require("../../../common/components/Button"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var ExperienceModal = function ExperienceModal(_ref) {
    var errorMessage = _ref.errorMessage,
        experienceId = _ref.experienceId,
        hasSegmentsPermission = _ref.hasSegmentsPermission,
        _ref$initialName = _ref.initialName,
        initialName = _ref$initialName === void 0 ? '' : _ref$initialName,
        observer = _ref.observer,
        onErrorDismiss = _ref.onErrorDismiss,
        onClose = _ref.onClose,
        onNewSegmentClick = _ref.onNewSegmentClick,
        onSubmit = _ref.onSubmit,
        segmentId = _ref.segmentId,
        _ref$segments = _ref.segments,
        segments = _ref$segments === void 0 ? [] : _ref$segments;

    var _useState = (0, _react.useState)(segmentId !== undefined ? segmentId : segments[0] && segments[0].segmentsEntryId),
        _useState2 = _slicedToArray(_useState, 2),
        selectedSegmentId = _useState2[0],
        setSelectedSegmentId = _useState2[1];

    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

    var _useState3 = (0, _react.useState)(initialName),
        _useState4 = _slicedToArray(_useState3, 2),
        name = _useState4[0],
        setName = _useState4[1];

    var _useState5 = (0, _react.useState)(false),
        _useState6 = _slicedToArray(_useState5, 2),
        requiredNameError = _useState6[0],
        setRequiredNameError = _useState6[1];

    var _useState7 = (0, _react.useState)(false),
        _useState8 = _slicedToArray(_useState7, 2),
        requiredSegmentError = _useState8[0],
        setRequiredSegmentError = _useState8[1];

    var _useState9 = (0, _react.useState)(false),
        _useState10 = _slicedToArray(_useState9, 2),
        loading = _useState10[0],
        setLoading = _useState10[1];

    var handleFormSubmit = function handleFormSubmit(event) {
      event.preventDefault();

      var validName = _getValidValue(name);

      var validSegmentId = _getValidValue(selectedSegmentId);

      if (!validName || !validSegmentId) {
        if (!validName) {
          setRequiredNameError(true);
        }

        if (!validSegmentId) {
          setRequiredSegmentError(true);
        }
      } else {
        setLoading(true);
        onSubmit({
          name: name,
          segmentsEntryId: selectedSegmentId,
          segmentsExperienceId: experienceId
        })["finally"](function () {
          if (isMounted()) {
            setLoading(false);
          }
        });
      }
    };

    var nameInputId = "".concat(_index.config.portletNamespace, "segmentsExperienceName");
    var segmentSelectId = "".concat(_index.config.portletNamespace, "segmentsExperienceSegment");
    var nameGroupClassName = (0, _classnames["default"])('my-2', {
      'has-error': requiredNameError
    });
    var segmentGroupClassName = (0, _classnames["default"])('my-2', {
      'has-error': requiredSegmentError
    });
    var modalTitle = experienceId ? Liferay.Language.get('edit-experience') : Liferay.Language.get('new-experience');
    return _react["default"].createElement(_modal["default"], {
      observer: observer,
      size: "md"
    }, _react["default"].createElement(_modal["default"].Header, null, modalTitle), _react["default"].createElement(_modal["default"].Body, null, _react["default"].createElement(_form["default"], {
      autoComplete: "off",
      className: "mb-3",
      noValidate: true,
      onSubmit: handleFormSubmit
    }, errorMessage && _react["default"].createElement(_alert["default"], {
      displayType: "danger",
      onClose: onErrorDismiss,
      title: errorMessage
    }), _react["default"].createElement(_form["default"].Group, {
      className: nameGroupClassName
    }, _react["default"].createElement("label", {
      htmlFor: nameInputId
    }, Liferay.Language.get('name'), _react["default"].createElement(_icon["default"], {
      className: "ml-1 reference-mark",
      focusable: "false",
      role: "presentation",
      symbol: "asterisk"
    })), _react["default"].createElement(_form.ClayInput, {
      autoFocus: true,
      id: nameInputId,
      onChange: function handleNameChange(event) {
        var value = event.target.value;

        if (!_getValidValue(value)) {
          setRequiredNameError(true);
        } else {
          setRequiredNameError(false);
        }

        setName(value);
      },
      placeholder: Liferay.Language.get('experience-name'),
      required: true,
      type: "text",
      value: name
    }), requiredNameError && _react["default"].createElement(_form["default"].FeedbackItem, null, _react["default"].createElement(_form["default"].FeedbackIndicator, {
      className: "mr-1",
      symbol: "exclamation-full"
    }), Liferay.Language.get('an-experience-name-is-required'))), _react["default"].createElement(_form["default"].Group, {
      className: segmentGroupClassName
    }, _react["default"].createElement("label", {
      htmlFor: segmentSelectId
    }, Liferay.Language.get('audience'), _react["default"].createElement(_icon["default"], {
      className: "ml-1 reference-mark",
      focusable: "false",
      role: "presentation",
      symbol: "asterisk"
    })), _react["default"].createElement("div", {
      className: "d-flex"
    }, _react["default"].createElement(_form.ClaySelect, {
      disabled: segments.length === 0,
      id: segmentSelectId,
      onChange: function handleSegmentChange(event) {
        var value = event.target.value;

        if (!_getValidValue(value)) {
          setRequiredSegmentError(true);
        } else {
          setRequiredSegmentError(false);
        }

        setSelectedSegmentId(event.target.value);
      },
      value: selectedSegmentId
    }, segments.length ? segments.map(function (segment) {
      return _react["default"].createElement(_form.ClaySelect.Option, {
        key: segment.segmentsEntryId,
        label: segment.name,
        value: segment.segmentsEntryId
      });
    }) : _react["default"].createElement(_form.ClaySelect.Option, {
      label: Liferay.Language.get('no-segments'),
      value: ""
    })), hasSegmentsPermission === true && _react["default"].createElement(_Button["default"], {
      className: "flex-shrink-0 ml-2",
      disabled: loading,
      displayType: "secondary",
      onClick: function handleNewSegmentClick(event) {
        event.preventDefault();
        onNewSegmentClick({
          experienceId: experienceId,
          experienceName: name,
          segmentId: selectedSegmentId
        });
      },
      type: "button"
    }, Liferay.Language.get('new-segment'))), requiredSegmentError && _react["default"].createElement(_form["default"].FeedbackItem, null, _react["default"].createElement(_form["default"].FeedbackIndicator, {
      symbol: "exclamation"
    }), Liferay.Language.get('an-audience-is-required'))))), _react["default"].createElement(_modal["default"].Footer, {
      last: _react["default"].createElement(_button["default"].Group, {
        spaced: true
      }, _react["default"].createElement(_button["default"], {
        disabled: loading,
        displayType: "secondary",
        onClick: onClose
      }, Liferay.Language.get('cancel')), _react["default"].createElement(_Button["default"], {
        disabled: loading,
        displayType: "primary",
        loading: loading,
        onClick: handleFormSubmit
      }, Liferay.Language.get('save')))
    }));
  };

  function _getValidValue(value) {
    return value && value.replace(/ /g, '');
  }

  var _default = ExperienceModal;
  exports["default"] = _default;
  //# sourceMappingURL=ExperienceModal.js.map
});
//# sourceMappingURL=ExperienceModal.js.map