Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/plugins/experience/components/ExperienceItem", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../statuses', '../types', './ExperimentLabel', './Popover'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _button = require("@frontend-taglib-clay$clayui/button");

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _statuses = require("../statuses");

  var _types = require("../types");

  var _ExperimentLabel = _interopRequireDefault(require("./ExperimentLabel"));

  var _Popover = _interopRequireDefault(require("./Popover"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var ExperienceItem = function ExperienceItem(_ref) {
    var active = _ref.active,
        editable = _ref.editable,
        experience = _ref.experience,
        lockedDecreasePriority = _ref.lockedDecreasePriority,
        lockedIncreasePriority = _ref.lockedIncreasePriority,
        onDeleteExperience = _ref.onDeleteExperience,
        onEditExperience = _ref.onEditExperience,
        onPriorityDecrease = _ref.onPriorityDecrease,
        onPriorityIncrease = _ref.onPriorityIncrease,
        onSelect = _ref.onSelect;

    var iconRef = _react["default"].useRef();

    var _React$useState = _react["default"].useState(false),
        _React$useState2 = _slicedToArray(_React$useState, 2),
        showtoolTip = _React$useState2[0],
        setShowtoolTip = _React$useState2[1];

    var itemClassName = (0, _classnames["default"])('d-flex dropdown-menu__experience', {
      'dropdown-menu__experience--active': active
    });
    return _react["default"].createElement("li", {
      "aria-checked": active,
      className: itemClassName,
      role: "listitem"
    }, _react["default"].createElement("span", {
      className: "overflow-hidden p-2 w-100"
    }, _react["default"].createElement("button", {
      className: "align-items-baseline btn btn-unstyled d-flex justify-content-between p-2 text-dark title w-100",
      onClick: function handleSelect() {
        return onSelect(experience.segmentsExperienceId);
      },
      type: "button"
    }, _react["default"].createElement("span", {
      className: "d-flex flex-column flex-grow-1 text-truncate"
    }, _react["default"].createElement("strong", {
      className: "text-truncate"
    }, experience.name, experience.hasLockedSegmentsExperiment && _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_icon["default"], {
      className: "ml-2 text-secondary",
      onMouseEnter: function onMouseEnter() {
        return setShowtoolTip(true);
      },
      onMouseLeave: function onMouseLeave() {
        return setShowtoolTip(false);
      },
      ref: iconRef,
      symbol: "lock"
    }), showtoolTip && _react["default"].createElement(_Popover["default"], {
      anchor: iconRef.current,
      header: Liferay.Language.get('experience-locked')
    }, Liferay.Language.get('edit-is-not-allowed-for-this-experience')))), _react["default"].createElement("span", {
      className: "audience d-block text-truncate"
    }, _react["default"].createElement("span", {
      className: "mr-1 text-secondary"
    }, Liferay.Language.get('audience')), experience.segmentsEntryName), experience.segmentsExperimentStatus && _react["default"].createElement("div", null, _react["default"].createElement("span", {
      className: "font-weight-normal mr-1 text-secondary"
    }, Liferay.Language.get('ab-test')), _react["default"].createElement(_ExperimentLabel["default"], {
      label: experience.segmentsExperimentStatus.label,
      value: experience.segmentsExperimentStatus.value
    }))))), editable && _react["default"].createElement("div", {
      className: "align-items-center d-flex dropdown-menu__experience--btn-group px-2"
    }, _react["default"].createElement(_button.ClayButtonWithIcon, {
      className: "component-action mx-2 text-secondary",
      disabled: lockedIncreasePriority,
      displayType: "unstyled",
      monospaced: true,
      onClick: function handlePriorityIncrease() {
        return onPriorityIncrease(experience.segmentsExperienceId, experience.priority);
      },
      small: true,
      symbol: "angle-up",
      title: Liferay.Language.get('prioritize-experience'),
      type: "button"
    }), _react["default"].createElement(_button.ClayButtonWithIcon, {
      className: "component-action mx-2 text-secondary",
      disabled: lockedDecreasePriority,
      displayType: "unstyled",
      monospaced: true,
      onClick: function handlePriorityDecrease() {
        return onPriorityDecrease(experience.segmentsExperienceId, experience.priority);
      },
      small: true,
      symbol: "angle-down",
      title: Liferay.Language.get('deprioritize-experience'),
      type: "button"
    }), _react["default"].createElement(_button.ClayButtonWithIcon, {
      className: "component-action mx-2 text-secondary",
      displayType: "unstyled",
      monospaced: true,
      onClick: function handleExperienceEdit() {
        var name = experience.name,
            segmentsEntryId = experience.segmentsEntryId,
            segmentsExperienceId = experience.segmentsExperienceId;
        onEditExperience({
          name: name,
          segmentsEntryId: segmentsEntryId,
          segmentsExperienceId: segmentsExperienceId
        });
      },
      small: true,
      symbol: "pencil",
      title: Liferay.Language.get('edit-experience'),
      type: "button"
    }), _react["default"].createElement(_button.ClayButtonWithIcon, {
      className: "component-action mx-2 text-secondary",
      displayType: "unstyled",
      monospaced: true,
      onClick: function handleExperienceDelete() {
        var experienceHasRunningExperiment = experience.segmentsExperimentStatus && experience.segmentsExperimentStatus.value === _statuses.STATUS_DRAFT;
        var confirmationMessage = experienceHasRunningExperiment ? Liferay.Language.get('delete-experience-with-running-test-confirmation-message') : Liferay.Language.get('do-you-want-to-delete-this-experience');
        var confirmed = confirm(confirmationMessage);

        if (confirmed) {
          onDeleteExperience(experience.segmentsExperienceId);
        }
      },
      small: true,
      symbol: "times-circle",
      title: Liferay.Language.get('delete-experience'),
      type: "button"
    })), experience.hasLockedSegmentsExperiment && experience.segmentsExperimentURL && _react["default"].createElement("div", {
      className: "align-items-center d-flex dropdown-menu__experience--btn-group px-2"
    }, _react["default"].createElement("a", {
      className: "btn btn-borderless btn-monospaced btn-sm btn-unstyled component-action mr-0 mx-2 text-secondary",
      href: experience.segmentsExperimentURL,
      onClick: function handleExperimentNavigation(event) {
        event.preventDefault();
        Liferay.Util.Session.set('com.liferay.segments.experiment.web_panelState', 'open').then(function () {
          Liferay.Util.navigate(experience.segmentsExperimentURL);
        });
      },
      title: Liferay.Language.get('go-to-test-details')
    }, _react["default"].createElement(_icon["default"], {
      symbol: "test"
    }))));
  };

  var _default = ExperienceItem;
  exports["default"] = _default;
  //# sourceMappingURL=ExperienceItem.js.map
});
//# sourceMappingURL=ExperienceItem.js.map