Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/plugins/comments/components/FragmentComment", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../app/config/constants/highlightedCommentIdKey', '../../../app/services/FragmentService', '../../../app/store/index', '../../../app/thunks/deleteFragmentComment', '../../../common/components/InlineConfirm', '../../../common/components/UserIcon', './EditCommentForm', './ReplyCommentForm', './ResolveButton'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = FragmentComment;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _frontendJsWeb = require("frontend-js-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _highlightedCommentIdKey = require("../../../app/config/constants/highlightedCommentIdKey");

  var _FragmentService = _interopRequireDefault(require("../../../app/services/FragmentService"));

  var _index = require("../../../app/store/index");

  var _deleteFragmentComment = _interopRequireDefault(require("../../../app/thunks/deleteFragmentComment"));

  var _InlineConfirm = _interopRequireDefault(require("../../../common/components/InlineConfirm"));

  var _UserIcon = _interopRequireDefault(require("../../../common/components/UserIcon"));

  var _EditCommentForm = _interopRequireDefault(require("./EditCommentForm"));

  var _ReplyCommentForm = _interopRequireDefault(require("./ReplyCommentForm"));

  var _ResolveButton = _interopRequireDefault(require("./ResolveButton"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function FragmentComment(_ref) {
    var comment = _ref.comment,
        fragmentEntryLinkId = _ref.fragmentEntryLinkId,
        onEdit = _ref.onEdit,
        parentCommentId = _ref.parentCommentId;
    var author = comment.author,
        body = comment.body,
        commentId = comment.commentId,
        dateDescription = comment.dateDescription,
        edited = comment.edited,
        modifiedDateDescription = comment.modifiedDateDescription,
        resolved = comment.resolved;

    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        changingResolved = _useState2[0],
        setChangingResolved = _useState2[1];

    var _useState3 = (0, _react.useState)(false),
        _useState4 = _slicedToArray(_useState3, 2),
        dropDownActive = _useState4[0],
        setDropDownActive = _useState4[1];

    var _useState5 = (0, _react.useState)(false),
        _useState6 = _slicedToArray(_useState5, 2),
        editing = _useState6[0],
        setEditing = _useState6[1];

    var _useState7 = (0, _react.useState)(false),
        _useState8 = _slicedToArray(_useState7, 2),
        hidden = _useState8[0],
        setHidden = _useState8[1];

    var _useState9 = (0, _react.useState)(false),
        _useState10 = _slicedToArray(_useState9, 2),
        highlighted = _useState10[0],
        setHighlighted = _useState10[1];

    var _useState11 = (0, _react.useState)(false),
        _useState12 = _slicedToArray(_useState11, 2),
        showDeleteMask = _useState12[0],
        setShowDeleteMask = _useState12[1];

    var _useState13 = (0, _react.useState)(false),
        _useState14 = _slicedToArray(_useState13, 2),
        showResolveMask = _useState14[0],
        setShowResolveMask = _useState14[1];

    var showResolvedComments = (0, _index.useSelector)(function (state) {
      return state.showResolvedComments;
    });
    var dispatch = (0, _index.useDispatch)();
    var showModifiedDateTooltip = !!(edited && modifiedDateDescription);
    var commentClassname = (0, _classnames["default"])('small', {
      'page-editor__fragment-comment': true,
      'page-editor__fragment-comment--hidden': hidden,
      'page-editor__fragment-comment--highlighted': highlighted,
      'page-editor__fragment-comment--reply': !!parentCommentId,
      'page-editor__fragment-comment--resolved': resolved,
      'page-editor__fragment-comment--with-delete-mask': showDeleteMask,
      'page-editor__fragment-comment--with-resolve-mask': showResolveMask
    });

    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

    var hideComment = function hideComment(onHide) {
      setHidden(true);
      setTimeout(function () {
        if (isMounted()) {
          setShowDeleteMask(false);
          setShowResolveMask(false);
          onHide();
        }
      }, 1000);
    };

    (0, _react.useEffect)(function () {
      var highlightMessageId = window.sessionStorage.getItem(_highlightedCommentIdKey.HIGHLIGHTED_COMMENT_ID_KEY);

      if (highlightMessageId === commentId) {
        window.sessionStorage.removeItem(_highlightedCommentIdKey.HIGHLIGHTED_COMMENT_ID_KEY);
        setHighlighted(true);
      }
    }, [commentId]);
    return _react["default"].createElement("article", {
      className: commentClassname
    }, _react["default"].createElement("div", {
      className: "d-flex mb-2"
    }, _react["default"].createElement(_UserIcon["default"], author), _react["default"].createElement("div", {
      className: "flex-grow-1 overflow-hidden pl-2"
    }, _react["default"].createElement("p", {
      className: "m-0 text-truncate"
    }, _react["default"].createElement("strong", {
      className: "lfr-portal-tooltip",
      "data-title": author.fullName
    }, author.fullName)), _react["default"].createElement("p", {
      className: (0, _classnames["default"])('m-0 text-secondary', {
        'lfr-portal-tooltip': showModifiedDateTooltip
      }),
      "data-title": showModifiedDateTooltip && Liferay.Util.sub(Liferay.Language.get('edited-x'), modifiedDateDescription)
    }, dateDescription)), !parentCommentId && _react["default"].createElement(_ResolveButton["default"], {
      disabled: editing,
      loading: changingResolved,
      onClick: function handleResolveButtonClick() {
        setChangingResolved(true);

        _FragmentService["default"].editComment({
          body: body,
          commentId: commentId,
          onNetworkStatus: dispatch,
          resolved: !resolved
        }).then(function (comment) {
          setChangingResolved(false);

          if (showResolvedComments) {
            onEdit(comment);
          } else if (!resolved) {
            setShowResolveMask(true);
            hideComment(function () {
              return onEdit(comment);
            });
          }
        })["catch"](function () {
          (0, _frontendJsWeb.openToast)({
            message: resolved ? Liferay.Language.get('the-comment-could-not-be-unresolved') : Liferay.Language.get('the-comment-could-not-be-resolved'),
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
          setChangingResolved(false);
        });
      },
      resolved: resolved
    }), Liferay.ThemeDisplay.getUserId() === author.userId && _react["default"].createElement(_dropDown["default"], {
      active: dropDownActive,
      onActiveChange: setDropDownActive,
      trigger: _react["default"].createElement(_button["default"], {
        borderless: true,
        disabled: editing,
        displayType: "secondary",
        monospaced: true,
        outline: true,
        small: true
      }, _react["default"].createElement(_icon["default"], {
        symbol: "ellipsis-v"
      }))
    }, _react["default"].createElement(_dropDown["default"].ItemList, null, _react["default"].createElement(_dropDown["default"].Item, {
      disabled: resolved,
      onClick: function onClick() {
        setDropDownActive(false);
        setEditing(true);
      }
    }, Liferay.Language.get('edit')), _react["default"].createElement(_dropDown["default"].Item, {
      onClick: function onClick() {
        setDropDownActive(false);
        setShowDeleteMask(true);
      }
    }, Liferay.Language.get('delete'))))), editing ? _react["default"].createElement(_EditCommentForm["default"], {
      comment: comment,
      fragmentEntryLinkId: fragmentEntryLinkId,
      onCloseForm: function onCloseForm() {
        return setEditing(false);
      }
    }) : _react["default"].createElement("div", {
      className: "content pb-2 text-secondary",
      dangerouslySetInnerHTML: {
        __html: body
      }
    }), !parentCommentId && comment.children && Boolean(comment.children.length) && _react["default"].createElement("footer", {
      className: "mb-2 page-editor__fragment-comment-replies"
    }, comment.children && comment.children.map(function (childComment) {
      return _react["default"].createElement(FragmentComment, {
        comment: _objectSpread({}, childComment, {
          parentCommentId: comment.commentId,
          resolved: resolved
        }),
        fragmentEntryLinkId: fragmentEntryLinkId,
        key: childComment.commentId,
        parentCommentId: commentId
      });
    })), !parentCommentId && _react["default"].createElement(_ReplyCommentForm["default"], {
      disabled: editing || resolved,
      fragmentEntryLinkId: fragmentEntryLinkId,
      parentCommentId: commentId
    }), showDeleteMask && _react["default"].createElement(_InlineConfirm["default"], {
      cancelButtonLabel: Liferay.Language.get('cancel'),
      confirmButtonLabel: Liferay.Language.get('delete'),
      message: Liferay.Language.get('are-you-sure-you-want-to-delete-this-comment'),
      onCancelButtonClick: function onCancelButtonClick() {
        return setShowDeleteMask(false);
      },
      onConfirmButtonClick: function onConfirmButtonClick() {
        return dispatch((0, _deleteFragmentComment["default"])({
          commentId: commentId,
          fragmentEntryLinkId: fragmentEntryLinkId,
          parentCommentId: parentCommentId
        }))["catch"](function () {
          (0, _frontendJsWeb.openToast)({
            message: Liferay.Language.get('the-comment-could-not-be-deleted'),
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
        });
      }
    }), showResolveMask && _react["default"].createElement("div", {
      className: "resolve-mask"
    }, _react["default"].createElement(_icon["default"], {
      symbol: "check-circle"
    })));
  }
  //# sourceMappingURL=FragmentComment.js.map
});
//# sourceMappingURL=FragmentComment.js.map