Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/plugins/comments/components/CommentsSidebar", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../app/components/Controls', '../../../app/config/constants/layoutDataItemTypes', '../../../app/store/index', './FragmentComments', './FragmentEntryLinksWithComments'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = CommentsSidebar;

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _Controls = require("../../../app/components/Controls");

  var _layoutDataItemTypes = require("../../../app/config/constants/layoutDataItemTypes");

  var _index = require("../../../app/store/index");

  var _FragmentComments = _interopRequireDefault(require("./FragmentComments"));

  var _FragmentEntryLinksWithComments = _interopRequireDefault(require("./FragmentEntryLinksWithComments"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function getActiveFragmentEntryLink(itemId, fragmentEntryLinks, layoutData) {
    var item = layoutData.items[itemId];

    if (item) {
      if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment) {
        return fragmentEntryLinks[item.config.fragmentEntryLinkId];
      } else if (item.parentId) {
        return getActiveFragmentEntryLink(item.parentId, fragmentEntryLinks, layoutData);
      }
    }

    return null;
  }

  function CommentsSidebar() {
    var fragmentEntryLinks = (0, _index.useSelector)(function (state) {
      return state.fragmentEntryLinks;
    });
    var layoutData = (0, _index.useSelector)(function (state) {
      return state.layoutData;
    });
    var activeItemId = (0, _Controls.useActiveItemId)();
    var activeFragmentEntryLink = getActiveFragmentEntryLink(activeItemId, fragmentEntryLinks, layoutData);
    return _react["default"].createElement("div", {
      onMouseDown: function onMouseDown(event) {
        return event.nativeEvent.stopImmediatePropagation();
      }
    }, activeFragmentEntryLink ? _react["default"].createElement(_FragmentComments["default"], {
      fragmentEntryLink: activeFragmentEntryLink
    }) : _react["default"].createElement(_FragmentEntryLinksWithComments["default"], null));
  }
  //# sourceMappingURL=CommentsSidebar.js.map
});
//# sourceMappingURL=CommentsSidebar.js.map