Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/core/openInfoItemSelector", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.openInfoItemSelector = openInfoItemSelector;

  var _frontendJsWeb = require("frontend-js-web");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function openInfoItemSelector(callback, eventName, itemSelectorURL) {
    var destroyedCallback = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    var itemSelectorDialog = new _frontendJsWeb.ItemSelectorDialog({
      eventName: eventName,
      singleSelect: true,
      title: Liferay.Language.get('select'),
      url: itemSelectorURL
    });
    itemSelectorDialog.on('selectedItemChange', function (event) {
      var selectedItem = event.selectedItem;

      if (selectedItem && selectedItem.value) {
        var infoItem = _objectSpread({}, JSON.parse(selectedItem.value), {
          type: selectedItem.returnType
        });

        callback(infoItem);
      }
    });
    itemSelectorDialog.on('visibleChange', function (event) {
      if (!event.newVal && destroyedCallback && typeof destroyedCallback === 'function') {
        destroyedCallback();
      }
    });
    itemSelectorDialog.open();
  }
  //# sourceMappingURL=openInfoItemSelector.js.map
});
//# sourceMappingURL=openInfoItemSelector.js.map