Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/core/openImageSelector", ['module', 'exports', 'require', 'frontend-js-web', '../app/config/index'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.openImageSelector = openImageSelector;

  var _frontendJsWeb = require("frontend-js-web");

  var _index = require("../app/config/index");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function openImageSelector(callback) {
    var destroyedCallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    var itemSelectorDialog = new _frontendJsWeb.ItemSelectorDialog({
      eventName: "".concat(_index.config.portletNamespace, "selectImage"),
      singleSelect: true,
      title: Liferay.Language.get('select'),
      url: _index.config.imageSelectorURL
    });
    itemSelectorDialog.on('selectedItemChange', function (event) {
      var selectedItem = event.selectedItem || {};
      var returnType = selectedItem.returnType,
          value = selectedItem.value;

      if (returnType) {
        var selectedImage = {};

        if (returnType === 'URL') {
          selectedImage.title = '';
          selectedImage.url = value;
        } else {
          var fileEntry = JSON.parse(value);
          selectedImage.title = fileEntry.title;
          selectedImage.url = fileEntry.url;
        }

        callback(selectedImage);
      } else {
        if (destroyedCallback) {
          destroyedCallback();
        }
      }
    });
    itemSelectorDialog.on('visibleChange', function () {
      if (destroyedCallback) {
        destroyedCallback();
      }
    });
    itemSelectorDialog.open();
  }
  //# sourceMappingURL=openImageSelector.js.map
});
//# sourceMappingURL=openImageSelector.js.map