Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/core/createDNDBackend", ['module', 'exports', 'require', 'frontend-js-react-web$react-dnd-html5-backend'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = createDNDBackend;

  var _reactDndHtml5Backend = _interopRequireDefault(require("frontend-js-react-web$react-dnd-html5-backend"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function createDNDBackend(manager, mainContext) {
    /**
     * @type {Set<Window>}
     */
    var contexts = new Set();
    /**
     * @type {Map<Window, {backend: object, nodes: Map<string, HTMLElement>}>}
     */

    var connections = new Map();

    var handleDragAndDropEvent = function handleDragAndDropEvent(methodName) {
      return function (itemId, node, options) {
        contexts.forEach(function (context) {
          if (context.document.body && context.document.body.contains(node)) {
            var connection = connections.get(context);

            if (connection.nodes.get(itemId) !== node) {
              connection.nodes.set(itemId, node);
              connection.backend[methodName](itemId, node, options);
            }
          }
        });
      };
    };

    return {
      connectDragPreview: handleDragAndDropEvent('connectDragPreview'),
      connectDragSource: handleDragAndDropEvent('connectDragSource'),
      connectDropTarget: handleDragAndDropEvent('connectDropTarget'),
      setup: function setup() {
        contexts.add(mainContext);
        Array.from(mainContext.document.querySelectorAll('iframe')).forEach(function (iframe) {
          if (iframe.contentWindow) {
            contexts.add(iframe.contentWindow);
          }
        });
        contexts.forEach(function (context) {
          if (!connections.has(context)) {
            var backend = (0, _reactDndHtml5Backend["default"])(manager, context);
            backend.setup();
            connections.set(context, {
              backend: backend,
              nodes: new Map()
            });
          }
        });
      },
      teardown: function teardown() {
        contexts.forEach(function (context) {
          var connection = connections.get(context);

          if (connection) {
            connection.backend.teardown();
            connections["delete"](context);
          }
        });
        contexts.clear();
      }
    };
  }
  //# sourceMappingURL=createDNDBackend.js.map
});
//# sourceMappingURL=createDNDBackend.js.map