Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/utils/useParseURL", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../actions/index', '../components/Controls', '../config/constants/highlightedCommentIdKey', '../store/index'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = useParseURL;

  var _react = require("frontend-js-react-web$react");

  var _index = require("../actions/index");

  var _Controls = require("../components/Controls");

  var _highlightedCommentIdKey = require("../config/constants/highlightedCommentIdKey");

  var _index2 = require("../store/index");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function useParseURL() {
    var fragmentEntryLinks = (0, _index2.useSelector)(function (state) {
      return state.fragmentEntryLinks;
    });
    var layoutData = (0, _index2.useSelector)(function (state) {
      return state.layoutData;
    });
    var dispatch = (0, _index2.useDispatch)();
    var selectItem = (0, _Controls.useSelectItem)();
    var selectFragment = (0, _react.useCallback)(function (messageId) {
      var _ref = Object.values(fragmentEntryLinks).find(function (fragmentEntryLink) {
        return fragmentEntryLink.comments.find(function (comment) {
          return comment.commentId === messageId || comment.children.find(function (childComment) {
            return childComment.commentId === messageId;
          });
        });
      }) || {
        fragmentEntryLinkId: null
      },
          fragmentEntryLinkId = _ref.fragmentEntryLinkId;

      var _ref2 = Object.values(layoutData.items).find(function (item) {
        return item.config.fragmentEntryLinkId === fragmentEntryLinkId;
      }) || {
        itemId: null
      },
          itemId = _ref2.itemId;

      if (itemId) {
        selectItem(itemId);
        dispatch((0, _index.switchSidebarPanel)({
          sidebarOpen: true,
          sidebarPanelId: 'comments'
        }));
      }
    }, [dispatch, fragmentEntryLinks, layoutData.items, selectItem]);
    (0, _react.useEffect)(function () {
      var url = new URL(window.location.href);

      if (url.searchParams.has('messageId')) {
        window.sessionStorage.setItem(_highlightedCommentIdKey.HIGHLIGHTED_COMMENT_ID_KEY, url.searchParams.get('messageId'));
        selectFragment(url.searchParams.get('messageId'));
        url.searchParams["delete"]('messageId');
        var skipLoadPopstate;

        if (Liferay.SPA && Liferay.SPA.app) {
          skipLoadPopstate = Liferay.SPA.app.skipLoadPopstate;
          Liferay.SPA.app.skipLoadPopstate = true;
        }

        history.replaceState(null, document.head.title, url.href);
        requestAnimationFrame(function () {
          if (Liferay.SPA && Liferay.SPA.app && typeof skipLoadPopstate === 'boolean') {
            Liferay.SPA.app.skipLoadPopstate = skipLoadPopstate;
          }
        });
      }
    }, [selectFragment]);
  }
  //# sourceMappingURL=useParseURL.js.map
});
//# sourceMappingURL=useParseURL.js.map