Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/utils/useDragAndDrop", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', 'frontend-js-react-web$react-dnd-html5-backend', '../components/CollectionItemContext', '../components/Controls', '../components/layout-data-items/Collection', '../config/constants/layoutDataItemTypes'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.useDragItem = useDragItem;
  exports.useDragSymbol = useDragSymbol;
  exports.useDropClear = useDropClear;
  exports.useDropTarget = useDropTarget;
  exports.DragAndDropContextProvider = exports.TARGET_POSITION = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _reactDndHtml5Backend = require("frontend-js-react-web$react-dnd-html5-backend");

  var _CollectionItemContext = require("../components/CollectionItemContext");

  var _Controls = require("../components/Controls");

  var _Collection = require("../components/layout-data-items/Collection");

  var _layoutDataItemTypes = require("../config/constants/layoutDataItemTypes");

  var _LAYOUT_DATA_ALLOWED_;

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var LAYOUT_DATA_ALLOWED_CHILDREN_TYPES = (_LAYOUT_DATA_ALLOWED_ = {}, _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.root, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment]), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, []), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment]), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, []), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment]), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column]), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment]), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment, []), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragmentDropZone, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment]), _LAYOUT_DATA_ALLOWED_);
  var TARGET_POSITION = {
    BOTTOM: 'bottom',
    MIDDLE: 'middle',
    TOP: 'top'
  };
  exports.TARGET_POSITION = TARGET_POSITION;
  var DRAG_DROP_TARGET_TYPE = {
    DRAGGING_TO_ITSELF: 'itself',
    ELEVATE: 'elevate',
    INITIAL: 'initial',
    INSIDE: 'inside'
  };
  var initialDragDrop = {
    dispatch: null,
    layoutData: {
      items: []
    },
    state: {
      /**
       * Item that is being dragged
       */
      dropItem: null,

      /**
       * Target item where the item is being dragged true.
       * If elevate is true, dropTargetItem is the sibling
       * of drop item, otherwise is it's parent.
       */
      dropTargetItem: null,

      /**
       * When false, an "invalid drop" advise should be shown
       * to users.
       */
      droppable: true,

      /**
       * If true, dropTargetItem is the sibling of dropItem
       * and targetPosition determines the item index.
       */
      elevate: false,

      /**
       * Vertical position relative to dropTargetItem
       * (bottom, middle, top)
       */
      targetPositionWithMiddle: null,

      /**
       * Vertical position relative to dropTargetItem
       * (bottom, top)
       */
      targetPositionWithoutMiddle: null,

      /**
       * Source of the Drag and Drop status
       * (where the drag and drop status have been generated)
       */
      type: DRAG_DROP_TARGET_TYPE.INITIAL
    },
    targetRefs: new Map()
  };

  var DragAndDropContext = _react["default"].createContext(initialDragDrop);

  function useDragItem(sourceItem, onDragEnd) {
    var onBegin = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : function () {};
    var getSourceItem = (0, _react.useCallback)(function () {
      return sourceItem;
    }, [sourceItem]);

    var _useContext = (0, _react.useContext)(DragAndDropContext),
        dispatch = _useContext.dispatch,
        layoutData = _useContext.layoutData,
        state = _useContext.state;

    var sourceRef = (0, _react.useRef)(null);

    var _useDrag = (0, _reactDnd.useDrag)({
      begin: function begin() {
        onBegin();
      },
      collect: function collect(monitor) {
        return {
          isDraggingSource: monitor.isDragging()
        };
      },
      end: function end() {
        computeDrop({
          dispatch: dispatch,
          layoutData: layoutData,
          onDragEnd: onDragEnd,
          state: state
        });
      },
      item: {
        getSourceItem: getSourceItem,
        id: sourceItem.itemId,
        type: sourceItem.type
      }
    }),
        _useDrag2 = _slicedToArray(_useDrag, 3),
        isDraggingSource = _useDrag2[0].isDraggingSource,
        handlerRef = _useDrag2[1],
        previewRef = _useDrag2[2];

    (0, _react.useEffect)(function () {
      previewRef((0, _reactDndHtml5Backend.getEmptyImage)(), {
        captureDraggingState: true
      });
    }, [previewRef]);
    return {
      handlerRef: handlerRef,
      isDraggingSource: isDraggingSource,
      sourceRef: sourceRef
    };
  }

  function useDragSymbol(_ref, onDragEnd) {
    var label = _ref.label,
        type = _ref.type;
    var selectItem = (0, _Controls.useSelectItem)();
    var sourceItem = (0, _react.useMemo)(function () {
      return {
        isSymbol: true,
        itemId: label,
        type: type
      };
    }, [label, type]);

    var _useDragItem = useDragItem(sourceItem, onDragEnd, function () {
      return selectItem(null);
    }),
        handlerRef = _useDragItem.handlerRef,
        isDraggingSource = _useDragItem.isDraggingSource,
        sourceRef = _useDragItem.sourceRef;

    return {
      isDraggingSource: isDraggingSource,
      sourceRef: function symbolRef(element) {
        sourceRef.current = element;
        handlerRef(element);
      }
    };
  }

  function useDropClear() {
    var _useContext2 = (0, _react.useContext)(DragAndDropContext),
        dispatch = _useContext2.dispatch;

    var _useDrop = (0, _reactDnd.useDrop)({
      accept: Object.values(_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES),
      hover: function hover() {
        dispatch(initialDragDrop.state);
      }
    }),
        _useDrop2 = _slicedToArray(_useDrop, 2),
        dropClearRef = _useDrop2[1];

    return dropClearRef;
  }

  function useDropTarget(_targetItem) {
    var collectionItemIndex = (0, _CollectionItemContext.useCollectionItemIndex)();

    var _useContext3 = (0, _react.useContext)(DragAndDropContext),
        dispatch = _useContext3.dispatch,
        layoutData = _useContext3.layoutData,
        state = _useContext3.state,
        targetRefs = _useContext3.targetRefs;

    var targetRef = (0, _react.useRef)(null);
    var targetItem = (0, _react.useMemo)(function () {
      return _objectSpread({}, _targetItem, {
        collectionItemIndex: collectionItemIndex
      });
    }, [_targetItem, collectionItemIndex]);
    var isOverTarget = state.dropTargetItem && targetItem && toControlsId(layoutData, state.dropTargetItem) === toControlsId(layoutData, targetItem);

    var _useDrop3 = (0, _reactDnd.useDrop)({
      accept: Object.values(_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES),
      hover: function hover(_ref2, monitor) {
        var getSourceItem = _ref2.getSourceItem;
        computeHover({
          dispatch: dispatch,
          layoutData: layoutData,
          monitor: monitor,
          sourceItem: getSourceItem(),
          targetItem: targetItem,
          targetRefs: targetRefs
        });
      }
    }),
        _useDrop4 = _slicedToArray(_useDrop3, 2),
        setDropTargetRef = _useDrop4[1];

    (0, _react.useEffect)(function () {
      var itemId = toControlsId(layoutData, targetItem);
      targetRefs.set(itemId, targetRef);
      return function () {
        targetRefs["delete"](itemId);
      };
    }, [layoutData, targetItem, targetRef, targetRefs]);
    var setTargetRef = (0, _react.useCallback)(function (element) {
      setDropTargetRef(element);
      targetRef.current = element;
    }, [setDropTargetRef]);
    return {
      canDropOverTarget: state.droppable,
      isOverTarget: isOverTarget,
      sourceItem: state.dropItem,
      targetPosition: state.targetPositionWithMiddle,
      targetRef: setTargetRef
    };
  }

  var DragAndDropContextProvider = function DragAndDropContextProvider(_ref3) {
    var children = _ref3.children,
        layoutData = _ref3.layoutData;

    var _useReducer = (0, _react.useReducer)(function (state, nextState) {
      return Object.keys(state).some(function (key) {
        return state[key] !== nextState[key];
      }) ? nextState : state;
    }, initialDragDrop.state),
        _useReducer2 = _slicedToArray(_useReducer, 2),
        state = _useReducer2[0],
        reducerDispatch = _useReducer2[1];

    var targetRefs = (0, _react.useMemo)(function () {
      return new Map();
    }, []);
    var dispatch = (0, _react.useMemo)(function () {
      return (0, _frontendJsWeb.throttle)(reducerDispatch, 100);
    }, [reducerDispatch]);
    return _react["default"].createElement(DragAndDropContext.Provider, {
      value: {
        dispatch: dispatch,
        layoutData: layoutData,
        state: state,
        targetRefs: targetRefs
      }
    }, children);
  };

  exports.DragAndDropContextProvider = DragAndDropContextProvider;

  function computeDrop(_ref4) {
    var dispatch = _ref4.dispatch,
        layoutData = _ref4.layoutData,
        onDragEnd = _ref4.onDragEnd,
        state = _ref4.state;

    if (state.droppable && state.dropItem && state.dropTargetItem) {
      if (state.elevate) {
        var parentItem = layoutData.items[state.dropTargetItem.parentId];
        var siblingPosition = parentItem.children.indexOf(state.dropTargetItem.itemId);
        var position = Math.min(parentItem.children.includes(state.dropItem.itemId) ? parentItem.children.length - 1 : parentItem.children.length, state.targetPositionWithoutMiddle === TARGET_POSITION.BOTTOM ? siblingPosition + 1 : siblingPosition);
        onDragEnd(parentItem.itemId, position);
      } else {
        onDragEnd(state.dropTargetItem.itemId, state.dropTargetItem.children.length);
      }
    }

    dispatch(initialDragDrop.state);
  }

  function computeHover(_ref5) {
    var dispatch = _ref5.dispatch,
        layoutData = _ref5.layoutData,
        monitor = _ref5.monitor,
        _ref5$siblingItem = _ref5.siblingItem,
        siblingItem = _ref5$siblingItem === void 0 ? null : _ref5$siblingItem,
        sourceItem = _ref5.sourceItem,
        targetItem = _ref5.targetItem,
        targetRefs = _ref5.targetRefs;

    // Not dragging over direct child
    // We do not want to alter state here,
    // as dnd generate extra hover events when
    // items are being dragged over nested children
    if (!monitor.isOver({
      shallow: true
    })) {
      return;
    } // Dragging over itself or a descendant


    if (itemIsAncestor(sourceItem, targetItem, layoutData)) {
      return dispatch(_objectSpread({}, initialDragDrop.state, {
        type: DRAG_DROP_TARGET_TYPE.DRAGGING_TO_ITSELF
      }));
    } // Apparently valid drag, calculate vertical position and
    // nesting validation


    var _getItemPosition = getItemPosition(siblingItem || targetItem, monitor, layoutData, targetRefs),
        _getItemPosition2 = _slicedToArray(_getItemPosition, 3),
        targetPositionWithMiddle = _getItemPosition2[0],
        targetPositionWithoutMiddle = _getItemPosition2[1],
        elevationDepth = _getItemPosition2[2]; // Drop inside target


    if (!siblingItem && targetPositionWithMiddle === TARGET_POSITION.MIDDLE) {
      return dispatch({
        dropItem: sourceItem,
        dropTargetItem: targetItem,
        droppable: checkAllowedChild(sourceItem, targetItem, layoutData),
        elevate: null,
        targetPositionWithMiddle: targetPositionWithMiddle,
        targetPositionWithoutMiddle: targetPositionWithoutMiddle,
        type: DRAG_DROP_TARGET_TYPE.INSIDE
      });
    } // Valid elevation:
    // - dropItem should be child of dropTargetItem
    // - dropItem should be sibling of siblingItem


    if (siblingItem && checkAllowedChild(sourceItem, targetItem, layoutData)) {
      return dispatch({
        dropItem: sourceItem,
        dropTargetItem: siblingItem,
        droppable: true,
        elevate: true,
        targetPositionWithMiddle: targetPositionWithMiddle,
        targetPositionWithoutMiddle: targetPositionWithoutMiddle,
        type: DRAG_DROP_TARGET_TYPE.ELEVATE
      });
    } // Try to elevate to some valid ancestor
    // Using dropTargetItem parent as target and dropTargetItem as sibling
    // It will try elevate multiple levels if elevationDepth is enough and
    // there are valid ancestors


    if (elevationDepth) {
      var getElevatedTargetItem = function getElevatedTargetItem(sibling, maximumDepth) {
        var parent = layoutData.items[sibling.parentId] ? _objectSpread({}, layoutData.items[sibling.parentId], {
          collectionItemIndex: sibling.collectionItemIndex
        }) : null;

        if (parent) {
          var _getItemPosition3 = getItemPosition(sibling, monitor, layoutData, targetRefs),
              _getItemPosition4 = _slicedToArray(_getItemPosition3, 1),
              siblingPositionWithMiddle = _getItemPosition4[0];

          var _getItemPosition5 = getItemPosition(parent, monitor, layoutData, targetRefs),
              _getItemPosition6 = _slicedToArray(_getItemPosition5, 1),
              parentPositionWithMiddle = _getItemPosition6[0];

          if ((siblingPositionWithMiddle === targetPositionWithMiddle || parentPositionWithMiddle === targetPositionWithMiddle) && checkAllowedChild(sourceItem, parent, layoutData)) {
            if (maximumDepth > 1) {
              var _getElevatedTargetIte = getElevatedTargetItem(parent, maximumDepth - 1),
                  _getElevatedTargetIte2 = _slicedToArray(_getElevatedTargetIte, 2),
                  grandParent = _getElevatedTargetIte2[0],
                  parentSibling = _getElevatedTargetIte2[1];

              if (grandParent) {
                return [grandParent, parentSibling];
              }
            }

            return [parent, sibling];
          } else {
            return getElevatedTargetItem(parent, maximumDepth);
          }
        }

        return [null, null];
      };

      var _getElevatedTargetIte3 = getElevatedTargetItem(targetItem, elevationDepth),
          _getElevatedTargetIte4 = _slicedToArray(_getElevatedTargetIte3, 2),
          elevatedTargetItem = _getElevatedTargetIte4[0],
          _siblingItem = _getElevatedTargetIte4[1];

      if (elevatedTargetItem && elevatedTargetItem !== targetItem) {
        return computeHover({
          dispatch: dispatch,
          layoutData: layoutData,
          monitor: monitor,
          siblingItem: _siblingItem,
          sourceItem: sourceItem,
          targetItem: elevatedTargetItem,
          targetRefs: targetRefs
        });
      }
    }
  }
  /**
   * Checks if the given child can be nested inside given parent
   * @param {object} child
   * @param {object} parent
   * @return {boolean}
   */

  function checkAllowedChild(child, parent, layoutData) {
    var parentIsInsideCollection = function checkItemInsideCollection(item) {
      if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection) {
        return true;
      } else if (item.parentId) {
        return checkItemInsideCollection(layoutData.items[item.parentId]);
      }
    }(parent);

    if (parentIsInsideCollection && child.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection) {
      return false;
    }

    return LAYOUT_DATA_ALLOWED_CHILDREN_TYPES[parent.type].includes(child.type);
  }
  /**
   * Checks if the given parent is indeed parent of given child.
   * @param {object} child
   * @param {object} parent
   * @param {object} layoutData
   * @return {boolean}
   */

  function itemIsAncestor(child, parent, layoutData) {
    if (child && parent) {
      return child.itemId !== parent.itemId ? itemIsAncestor(child, layoutData.items[parent.parentId], layoutData) : true;
    }

    return false;
  }

  var ELEVATION_BORDER_SIZE = 15;
  var MAXIMUM_ELEVATION_STEPS = 3;
  /**
   * Returns the cursor vertical position (extracted from provided dnd monitor)
   * relative to the given item, taking into account configured elevation steps
   * with ELEVATION_BORDER_SIZE and MAXIMUM_ELEVATION_STEPS.
   *
   * For each elevation step, a border on the top/bottom of the element is added.
   * The first elevation step (being the nearest to the element's center)
   * elevates two its first valid ancestor, the second to the next one, and all
   * the way up until MAXIMUM_ELEVATION_STEPS has been reached or there are no
   * more valid ancestors.
   */

  function getItemPosition(item, monitor, layoutData, targetRefs) {
    var targetRef = targetRefs.get(toControlsId(layoutData, item));

    if (!targetRef || !targetRef.current) {
      return [null, null, 0];
    }

    var hoverBoundingRect = targetRef.current.getBoundingClientRect();
    var clientOffsetY = monitor.getClientOffset().y;
    var hoverMiddleY = hoverBoundingRect.top + hoverBoundingRect.height / 2;
    var elevationStepSize = Math.min(hoverBoundingRect.height / (2 * (MAXIMUM_ELEVATION_STEPS + 1)), ELEVATION_BORDER_SIZE);
    var totalElevationBorderSize = elevationStepSize * MAXIMUM_ELEVATION_STEPS;
    var targetPositionWithoutMiddle = clientOffsetY < hoverMiddleY ? TARGET_POSITION.TOP : TARGET_POSITION.BOTTOM;
    var targetPositionWithMiddle = clientOffsetY < hoverBoundingRect.bottom - totalElevationBorderSize && clientOffsetY > hoverBoundingRect.top + totalElevationBorderSize ? TARGET_POSITION.MIDDLE : targetPositionWithoutMiddle;
    var elevationDepth = 0;

    if (targetPositionWithMiddle !== TARGET_POSITION.MIDDLE) {
      var distanceFromBorder = targetPositionWithMiddle === TARGET_POSITION.TOP ? clientOffsetY - hoverBoundingRect.top : hoverBoundingRect.bottom - clientOffsetY;
      elevationDepth = MAXIMUM_ELEVATION_STEPS - Math.floor(distanceFromBorder / totalElevationBorderSize * MAXIMUM_ELEVATION_STEPS);
    }

    return [targetPositionWithMiddle, targetPositionWithoutMiddle, elevationDepth];
  }
  /**
   * Translates the given item ID into a collectionId-itemId if the item is
   * inside a collection. Otherwise, returns the plain itemId.
   * @param {object} layoutData
   * @param {object} item
   * @return {string}
   */

  function toControlsId(layoutData, item) {
    var baseItem = item;

    return function computeControlsId(layoutData, item) {
      var parent = layoutData.items[item.parentId];

      if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem && baseItem.collectionItemIndex && parent) {
        return (0, _Collection.getToControlsId)(parent.itemId, baseItem.collectionItemIndex)(baseItem.itemId);
      } else if (parent) {
        return computeControlsId(layoutData, parent);
      }

      return baseItem.itemId;
    }(layoutData, item);
  }
  //# sourceMappingURL=useDragAndDrop.js.map
});
//# sourceMappingURL=useDragAndDrop.js.map