Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/thunks/undo", ['module', 'exports', 'require', '../actions/types', '../components/undo/undoActions'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = undo;

  var _types = require("../actions/types");

  var _undoActions = require("../components/undo/undoActions");

  function _toArray(arr) {
    return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var promise = Promise.resolve();

  function undo(_ref) {
    var store = _ref.store;
    return function (dispatch) {
      if (!store.undoHistory || store.undoHistory.length === 0) {
        return;
      }

      var _ref2 = store.undoHistory || [],
          _ref3 = _toArray(_ref2),
          lastUndo = _ref3[0],
          undos = _ref3.slice(1);

      dispatch({
        type: _types.UPDATE_UNDO_ACTIONS,
        undoHistory: undos
      });
      promise = promise.then(function () {
        return (0, _undoActions.undoAction)({
          action: lastUndo,
          store: store
        })(dispatch);
      });
    };
  }
  //# sourceMappingURL=undo.js.map
});
//# sourceMappingURL=undo.js.map