Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/thunks/deleteItem", ['module', 'exports', 'require', '../actions/deleteItem', '../actions/deleteWidgets', '../actions/updatePageContents', '../services/InfoItemService', '../services/LayoutService'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = deleteItem;

  var _deleteItem = _interopRequireDefault(require("../actions/deleteItem"));

  var _deleteWidgets = _interopRequireDefault(require("../actions/deleteWidgets"));

  var _updatePageContents = _interopRequireDefault(require("../actions/updatePageContents"));

  var _InfoItemService = _interopRequireDefault(require("../services/InfoItemService"));

  var _LayoutService = _interopRequireDefault(require("../services/LayoutService"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function deleteItem(_ref) {
    var itemId = _ref.itemId,
        store = _ref.store;
    return function (dispatch) {
      var segmentsExperienceId = store.segmentsExperienceId;
      return _LayoutService["default"].deleteItem({
        itemId: itemId,
        onNetworkStatus: dispatch,
        segmentsExperienceId: segmentsExperienceId
      }).then(function (_ref2) {
        var _ref2$deletedFragment = _ref2.deletedFragmentEntryLinkIds,
            deletedFragmentEntryLinkIds = _ref2$deletedFragment === void 0 ? [] : _ref2$deletedFragment,
            layoutData = _ref2.layoutData;
        var deletedWidgets = deletedFragmentEntryLinkIds.map(function (fragmentEntryLinkId) {
          return store.fragmentEntryLinks[fragmentEntryLinkId];
        }).filter(function (fragmentEntryLink) {
          return fragmentEntryLink.editableValues.portletId;
        });

        if (deletedWidgets.length) {
          dispatch((0, _deleteWidgets["default"])(deletedWidgets));
        }

        dispatch((0, _deleteItem["default"])({
          deletedFragmentEntryLinkIds: deletedFragmentEntryLinkIds,
          itemId: itemId,
          layoutData: layoutData
        }));
      }).then(function () {
        _InfoItemService["default"].getPageContents({
          onNetworkStatus: dispatch
        }).then(function (pageContents) {
          dispatch((0, _updatePageContents["default"])({
            pageContents: pageContents
          }));
        });
      });
    };
  }
  //# sourceMappingURL=deleteItem.js.map
});
//# sourceMappingURL=deleteItem.js.map