Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/store/index", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../core/hooks/useThunk', '../components/undo/useUndo'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.useSelector = exports.useDispatch = exports.StoreContextProvider = exports.StoreAPIContextProvider = void 0;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _useThunk3 = _interopRequireDefault(require("../../core/hooks/useThunk"));

  var _useUndo = _interopRequireDefault(require("../components/undo/useUndo"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  var StoreContext = _react["default"].createContext(null);
  /**
   * Although StoreContextProvider creates a full functional store,
   * sometimes mocking dispatchs and/or store state may be necessary
   * for testing purposes.
   *
   * This component wraps it's children with an usable StoreContext
   * that calls dispatch and getState methods instead of using a real
   * reducer internally.
   */

  var StoreAPIContextProvider = function StoreAPIContextProvider(_ref) {
    var children = _ref.children,
        _ref$dispatch = _ref.dispatch,
        dispatch = _ref$dispatch === void 0 ? function () {} : _ref$dispatch,
        _ref$getState = _ref.getState,
        getState = _ref$getState === void 0 ? function () {
      return {};
    } : _ref$getState;
    var subscribers = (0, _react.useRef)([]);
    var subscribe = (0, _react.useCallback)(function (subscriber) {
      subscribers.current = [].concat(_toConsumableArray(subscribers.current), [subscriber]);
    }, []);
    var unsubscribe = (0, _react.useCallback)(function (subscriber) {
      subscribers.current = subscribers.current.filter(function (_subscriber) {
        return _subscriber !== subscriber;
      });
    }, []);
    (0, _react.useEffect)(function () {
      storeRef.current.dispatch = dispatch;
    }, [dispatch]);
    (0, _react.useEffect)(function () {
      storeRef.current.getState = getState;
      subscribers.current.forEach(function (subscriber) {
        return subscriber();
      });
    }, [getState]);
    var storeRef = (0, _react.useRef)({
      dispatch: dispatch,
      getState: getState,
      subscribe: subscribe,
      unsubscribe: unsubscribe
    });
    return _react["default"].createElement(StoreContext.Provider, {
      value: storeRef
    }, children);
  };
  /**
   * StoreContext is a black box for components: they should
   * get information from state and dispatch actions by using
   * given useSelector and useDispatch hooks.
   *
   * That's why we only provide a custom StoreContextProvider instead
   * of the raw React context.
   */

  exports.StoreAPIContextProvider = StoreAPIContextProvider;

  var StoreContextProvider = function StoreContextProvider(_ref2) {
    var children = _ref2.children,
        initialState = _ref2.initialState,
        reducer = _ref2.reducer;

    var _useThunk = (0, _useThunk3["default"])((0, _useUndo["default"])((0, _react.useReducer)(reducer, initialState))),
        _useThunk2 = _slicedToArray(_useThunk, 2),
        state = _useThunk2[0],
        dispatch = _useThunk2[1];

    var getState = (0, _react.useCallback)(function () {
      return state;
    }, [state]);
    return _react["default"].createElement(StoreAPIContextProvider, {
      dispatch: dispatch,
      getState: getState
    }, children);
  };
  /**
   * @see https://react-redux.js.org/api/hooks#usedispatch
   */

  exports.StoreContextProvider = StoreContextProvider;

  var useDispatch = function useDispatch() {
    var storeRef = (0, _react.useContext)(StoreContext);

    return storeRef.current.dispatch;
  };
  /**
   * @see https://react-redux.js.org/api/hooks#useselector
   */

  exports.useDispatch = useDispatch;

  var useSelector = function useSelector(selector) {
    var compareEqual = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function (a, b) {
      return a === b;
    };
    var storeRef = (0, _react.useContext)(StoreContext);

    var initialState = (0, _react.useMemo)(function () {
      return selector(storeRef.current.getState());
    }, // We really want to call selector here just on component mount.
    // This provides an initial value that will be recalculated when
    // store suscription has been called.
    // eslint-disable-next-line
    []);

    var _useState = (0, _react.useState)(initialState),
        _useState2 = _slicedToArray(_useState, 2),
        selectorState = _useState2[0],
        setSelectorState = _useState2[1];

    (0, _react.useEffect)(function () {
      var store = storeRef.current;

      var onStoreChange = function onStoreChange() {
        var nextState = selector(storeRef.current.getState());

        if (!compareEqual(selectorState, nextState)) {
          setSelectorState(nextState);
        }
      };

      store.subscribe(onStoreChange);
      return function () {
        store.unsubscribe(onStoreChange);
      };
    }, [selectorState, storeRef, selector, compareEqual]);
    return selectorState;
  };

  exports.useSelector = useSelector;
  //# sourceMappingURL=index.js.map
});
//# sourceMappingURL=index.js.map