Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/services/WidgetService", ['module', 'exports', 'require', '../config/index', './serviceFetch'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _index = require("../config/index");

  var _serviceFetch = _interopRequireDefault(require("./serviceFetch"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var _default = {
    /**
     * Adds a Widget to the current layout
     * @param {object} options
     * @param {function} options.onNetworkStatus
     * @param {string} options.portletId Portlet id of the Widget
     * @param {string} options.parentItemId id of the parent where the portlet is going to be added
     * @param {string} options.position position where the portlet is going to be added
     * @param {string} options.portletId Portlet id of the Widget
     * @param {string} options.segmentsExperienceId Current segmentsExperienceId
     * @return {Promise<object>}
     */
    addPortlet: function addPortlet(_ref) {
      var onNetworkStatus = _ref.onNetworkStatus,
          parentItemId = _ref.parentItemId,
          portletId = _ref.portletId,
          position = _ref.position,
          segmentsExperienceId = _ref.segmentsExperienceId;
      return (0, _serviceFetch["default"])(_index.config.addPortletURL, {
        body: {
          parentItemId: parentItemId,
          portletId: portletId,
          position: position,
          segmentsExperienceId: segmentsExperienceId
        }
      }, onNetworkStatus, {
        requestGenerateDraft: true
      });
    }
  };
  exports["default"] = _default;
  //# sourceMappingURL=WidgetService.js.map
});
//# sourceMappingURL=WidgetService.js.map