Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/services/LayoutService", ['module', 'exports', 'require', '../config/index', './serviceFetch'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _index = require("../config/index");

  var _serviceFetch = _interopRequireDefault(require("./serviceFetch"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var _default = {
    /**
     * Adds an item to layoutData
     * @param {object} options
     * @param {string} options.itemType item type
     * @param {function} options.onNetworkStatus
     * @param {object} options.parentItemId Parent to be added to
     * @param {object} options.position Position to be added to
     * @param {object} options.segmentsExperienceId
     * @return {Promise<object>}
     */
    addItem: function addItem(_ref) {
      var itemType = _ref.itemType,
          onNetworkStatus = _ref.onNetworkStatus,
          parentItemId = _ref.parentItemId,
          position = _ref.position,
          segmentsExperienceId = _ref.segmentsExperienceId;
      return layoutServiceFetch(_index.config.addItemURL, {
        body: {
          itemType: itemType,
          parentItemId: parentItemId,
          position: position,
          segmentsExperienceId: segmentsExperienceId
        }
      }, onNetworkStatus);
    },

    /**
     * Remove an item inside layoutData
     * @param {object} options
     * @param {object} options.itemId id of the item to be removed
     * @param {function} options.onNetworkStatus
     * @param {object} options.segmentsExperienceId
     * @return {Promise<object>}
     */
    deleteItem: function deleteItem(_ref2) {
      var itemId = _ref2.itemId,
          onNetworkStatus = _ref2.onNetworkStatus,
          segmentsExperienceId = _ref2.segmentsExperienceId;
      return layoutServiceFetch(_index.config.deleteItemURL, {
        body: {
          itemId: itemId,
          segmentsExperienceId: segmentsExperienceId
        }
      }, onNetworkStatus);
    },

    /**
     * Move an item inside layoutData
     * @param {object} options
     * @param {object} options.itemId id of the item to be moved
     * @param {object} options.parentItemId id of the target parent
     * @param {object} options.position position in the parent where the item is placed
     * @param {object} options.segmentsExperienceId
     * @param {function} options.onNetworkStatus
     * @return {Promise<object>}
     */
    moveItem: function moveItem(_ref3) {
      var itemId = _ref3.itemId,
          onNetworkStatus = _ref3.onNetworkStatus,
          parentItemId = _ref3.parentItemId,
          position = _ref3.position,
          segmentsExperienceId = _ref3.segmentsExperienceId;
      return layoutServiceFetch(_index.config.moveItemURL, {
        body: {
          itemId: itemId,
          parentItemId: parentItemId,
          position: position,
          segmentsExperienceId: segmentsExperienceId
        }
      }, onNetworkStatus);
    },

    /**
     * Updates a config into an item
     * @param {object} options
     * @param {object} options.itemConfig Updated item config
     * @param {string} options.itemId id of the item to be updated
     * @param {string} options.segmentsExperienceId Segments experience id
     * @param {function} options.onNetworkStatus
     * @return {Promise<void>}
     */
    updateItemConfig: function updateItemConfig(_ref4) {
      var itemConfig = _ref4.itemConfig,
          itemId = _ref4.itemId,
          onNetworkStatus = _ref4.onNetworkStatus,
          segmentsExperienceId = _ref4.segmentsExperienceId;
      return layoutServiceFetch(_index.config.updateItemConfigURL, {
        body: {
          itemConfig: JSON.stringify(itemConfig),
          itemId: itemId,
          segmentsExperienceId: segmentsExperienceId
        }
      }, onNetworkStatus);
    },

    /**
     * Updates layout's layoutData
     * @param {object} options
     * @param {string} options.segmentsExperienceId Current segmentsExperienceId
     * @param {object} options.layoutData New layoutData
     * @param {function} options.onNetworkStatus
     * @return {Promise<void>}
     */
    updateLayoutData: function updateLayoutData(_ref5) {
      var layoutData = _ref5.layoutData,
          onNetworkStatus = _ref5.onNetworkStatus,
          segmentsExperienceId = _ref5.segmentsExperienceId;
      return layoutServiceFetch(_index.config.updateLayoutPageTemplateDataURL, {
        body: {
          data: JSON.stringify(layoutData),
          segmentsExperienceId: segmentsExperienceId
        }
      }, onNetworkStatus);
    },

    /**
     * Updates the number of columns of a row
     * @param {object} options
     * @param {string} options.itemId id of the item to be updated
     * @param {number} options.numberOfColumns New number of columns
     * @param {string} options.segmentsExperienceId Segments experience id
     * @param {function} options.onNetworkStatus
     * @return {Promise<void>}
     */
    updateRowColumns: function updateRowColumns(_ref6) {
      var itemId = _ref6.itemId,
          numberOfColumns = _ref6.numberOfColumns,
          onNetworkStatus = _ref6.onNetworkStatus,
          segmentsExperienceId = _ref6.segmentsExperienceId;
      return layoutServiceFetch(_index.config.updateRowColumnsURL, {
        body: {
          itemId: itemId,
          numberOfColumns: numberOfColumns,
          segmentsExperienceId: segmentsExperienceId
        }
      }, onNetworkStatus);
    }
  };
  exports["default"] = _default;

  var layoutServiceFetch = function layoutServiceFetch(url, options, onNetworkStatus) {
    return (0, _serviceFetch["default"])(url, options, onNetworkStatus, {
      requestGenerateDraft: true
    });
  };
  //# sourceMappingURL=LayoutService.js.map
});
//# sourceMappingURL=LayoutService.js.map