Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/services/InfoItemService", ['module', 'exports', 'require', '../config/index', './serviceFetch'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _index = require("../config/index");

  var _serviceFetch = _interopRequireDefault(require("./serviceFetch"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var _default = {
    /**
     * Get an asset's value
     * @param {object} options
     * @param {string} options.classNameId Asset's className
     * @param {string} options.classPK Asset's classPK
     * @param {string} options.fieldId
     * @param {string} [options.languageId]
     * @param {function} options.onNetworkStatus
     */
    getAssetFieldValue: function getAssetFieldValue(_ref) {
      var classNameId = _ref.classNameId,
          classPK = _ref.classPK,
          fieldId = _ref.fieldId,
          languageId = _ref.languageId,
          onNetworkStatus = _ref.onNetworkStatus;
      return (0, _serviceFetch["default"])(_index.config.getAssetFieldValueURL, {
        body: {
          classNameId: classNameId,
          classPK: classPK,
          fieldId: fieldId,
          languageId: languageId
        }
      }, onNetworkStatus);
    },

    /**
     * Get available asset mapping fields
     * @param {object} options
     * @param {string} options.classNameId Asset's className
     * @param {string} options.classPK Asset's classPK
     * @param {function} options.onNetworkStatus
     */
    getAvailableAssetMappingFields: function getAvailableAssetMappingFields(_ref2) {
      var classNameId = _ref2.classNameId,
          classPK = _ref2.classPK,
          onNetworkStatus = _ref2.onNetworkStatus;
      return (0, _serviceFetch["default"])(_index.config.getAssetMappingFieldsURL, {
        body: {
          classNameId: classNameId,
          classPK: classPK
        }
      }, onNetworkStatus);
    },

    /**
     * Get available list renderers for the class name
     * @param {object} options
     * @param {string} options.className className
     * @param {function} options.onNetworkStatus
     */
    getAvailableListRenderers: function getAvailableListRenderers(_ref3) {
      var className = _ref3.className,
          onNetworkStatus = _ref3.onNetworkStatus;
      return (0, _serviceFetch["default"])(_index.config.getAvailableListRenderersURL, {
        body: {
          className: className
        }
      }, onNetworkStatus);
    },

    /**
     * Get available structure mapping fields
     * @param {object} options
     * @param {string} options.classNameId Asset's className
     * @param {string} options.classTypeId Asset's classTypeId
     * @param {function} options.onNetworkStatus
     */
    getAvailableStructureMappingFields: function getAvailableStructureMappingFields(_ref4) {
      var classNameId = _ref4.classNameId,
          classTypeId = _ref4.classTypeId,
          onNetworkStatus = _ref4.onNetworkStatus;
      return (0, _serviceFetch["default"])(_index.config.mappingFieldsURL, {
        body: {
          classNameId: classNameId,
          classTypeId: classTypeId
        }
      }, onNetworkStatus);
    },

    /**
     * Get available templates for an asset
     * @param {object} options
     * @param {string} options.className Asset's className
     * @param {string} options.classPK Asset's classPK
     * @param {function} options.onNetworkStatus
     */
    getAvailableTemplates: function getAvailableTemplates(_ref5) {
      var className = _ref5.className,
          classPK = _ref5.classPK,
          onNetworkStatus = _ref5.onNetworkStatus;
      return (0, _serviceFetch["default"])(_index.config.getAvailableTemplatesURL, {
        body: {
          className: className,
          classPK: classPK
        }
      }, onNetworkStatus);
    },

    /**
     * Get page contents
     * @param {object} options
     * @param {function} options.onNetworkStatus
     */
    getPageContents: function getPageContents(_ref6) {
      var onNetworkStatus = _ref6.onNetworkStatus;
      return (0, _serviceFetch["default"])(_index.config.getPageContentsURL, {}, onNetworkStatus);
    }
  };
  exports["default"] = _default;
  //# sourceMappingURL=InfoItemService.js.map
});
//# sourceMappingURL=InfoItemService.js.map