Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/services/CollectionService", ['module', 'exports', 'require', '../config/index', './serviceFetch'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _index = require("../config/index");

  var _serviceFetch = _interopRequireDefault(require("./serviceFetch"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var _default = {
    /**
     * Get an asset's value
     * @param {object} options
     * @param {string} options.layoutObjectReference
     * @param {function} options.onNetworkStatus
     */
    getCollectionField: function getCollectionField(_ref) {
      var collection = _ref.collection,
          onNetworkStatus = _ref.onNetworkStatus,
          segmentsExperienceId = _ref.segmentsExperienceId,
          size = _ref.size;
      return (0, _serviceFetch["default"])(_index.config.getCollectionFieldURL, {
        body: {
          layoutObjectReference: JSON.stringify(collection),
          segmentsExperienceId: segmentsExperienceId,
          size: size
        }
      }, onNetworkStatus);
    },

    /**
     * Get available collection mapping fields
     * @param {object} options
     * @param {string} options.itemSubtype Collection itemSubtype
     * @param {string} options.itemType Collection itemType
     * @param {function} options.onNetworkStatus
     */
    getCollectionMappingFields: function getCollectionMappingFields(_ref2) {
      var itemSubtype = _ref2.itemSubtype,
          itemType = _ref2.itemType,
          onNetworkStatus = _ref2.onNetworkStatus;
      return (0, _serviceFetch["default"])(_index.config.getCollectionMappingFieldsURL, {
        body: {
          itemSubtype: itemSubtype,
          itemType: itemType
        }
      }, onNetworkStatus);
    }
  };
  exports["default"] = _default;
  //# sourceMappingURL=CollectionService.js.map
});
//# sourceMappingURL=CollectionService.js.map