Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/selectors/selectAvailableSidebarPanels", ['module', 'exports', 'require', './selectAvailablePanels'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = selectAvailableSidebarPanels;

  var _selectAvailablePanels = require("./selectAvailablePanels");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * @param {{ [panelId: string]: object }} sidebarPanels
   */
  function selectAvailableSidebarPanels(sidebarPanels) {
    /**
     * @param {{ permissions: import("../../types/ActionKeys").ActionKeysMap }} state
     */
    return function (_ref) {
      var permissions = _ref.permissions;

      if (permissions.LOCKED_SEGMENTS_EXPERIMENT || !permissions.UPDATE_LAYOUT_CONTENT) {
        var availableSidebarPanels = {};

        _selectAvailablePanels.AVAILABLE_PANELS.forEach(function (panelId) {
          availableSidebarPanels[panelId] = sidebarPanels[panelId];
        });

        return availableSidebarPanels;
      }

      return sidebarPanels;
    };
  }
  //# sourceMappingURL=selectAvailableSidebarPanels.js.map
});
//# sourceMappingURL=selectAvailableSidebarPanels.js.map