Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/selectors/selectAvailablePanels", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = selectAvailablePanels;
  exports.AVAILABLE_PANELS = void 0;

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var AVAILABLE_PANELS = ['comments', 'contents', 'page-structure'];
  /**
   * @param {Array<Array<string>>} panels
   */

  exports.AVAILABLE_PANELS = AVAILABLE_PANELS;

  function selectAvailablePanels(panels) {
    /**
     * @param {{ permissions: import("../../types/ActionKeys").ActionKeysMap }} state
     */
    return function (_ref) {
      var permissions = _ref.permissions;

      if (permissions.LOCKED_SEGMENTS_EXPERIMENT || !permissions.UPDATE_LAYOUT_CONTENT) {
        return panels.map(function (group) {
          return group.filter(function (panelId) {
            return AVAILABLE_PANELS.includes(panelId);
          });
        }).filter(function (group) {
          return group.length;
        });
      }

      return panels;
    };
  }
  //# sourceMappingURL=selectAvailablePanels.js.map
});
//# sourceMappingURL=selectAvailablePanels.js.map