Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/reducers/widgetsReducer", ['module', 'exports', 'require', '../actions/types'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = widgetsReducer;

  var _types = require("../actions/types");

  function _toArray(arr) {
    return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function widgetsReducer(widgets, action) {
    switch (action.type) {
      case _types.ADD_FRAGMENT_ENTRY_LINKS:
        {
          var fragmentEntryLinks = action.fragmentEntryLinks || [];
          var nextWidgets = widgets;
          fragmentEntryLinks.forEach(function (fragmentEntryLink) {
            if (fragmentEntryLink.editableValues && fragmentEntryLink.editableValues.portletId && !fragmentEntryLink.editableValues.instanceable) {
              var widgetPath = getWidgetPath(widgets, fragmentEntryLink.editableValues.portletId);
              nextWidgets = setWidgetUsage(nextWidgets, widgetPath, {
                used: true
              });
            }
          });
          return nextWidgets;
        }

      case _types.DELETE_WIDGETS:
        {
          var _nextWidgets = widgets;
          action.fragmentEntryLinks.forEach(function (fragmentEntryLink) {
            if (fragmentEntryLink.editableValues && fragmentEntryLink.editableValues.portletId && !fragmentEntryLink.editableValues.instanceable) {
              var widgetPath = getWidgetPath(_nextWidgets, fragmentEntryLink.editableValues.portletId);
              _nextWidgets = setWidgetUsage(_nextWidgets, widgetPath, {
                used: false
              });
            }
          });
          return _nextWidgets;
        }

      default:
        return widgets;
    }
  }
  /**
   * Get widget path from the widgets tree by portletId
   */

  function getWidgetPath(widgets, portletId) {
    var path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
    var widgetPath = null;

    for (var categoryIndex = 0; categoryIndex < widgets.length; categoryIndex += 1) {
      var _widgets$categoryInde = widgets[categoryIndex],
          _widgets$categoryInde2 = _widgets$categoryInde.categories,
          categories = _widgets$categoryInde2 === void 0 ? [] : _widgets$categoryInde2,
          _widgets$categoryInde3 = _widgets$categoryInde.portlets,
          portlets = _widgets$categoryInde3 === void 0 ? [] : _widgets$categoryInde3;
      var categoryPortletIndex = portlets.findIndex(function (_portlet) {
        return _portlet.portletId === portletId;
      });
      var subCategoryPortletPath = getWidgetPath(categories, portletId, [].concat(_toConsumableArray(path), [categoryIndex.toString(), 'categories']));

      if (categoryPortletIndex !== -1) {
        widgetPath = [].concat(_toConsumableArray(path), [categoryIndex, 'portlets', categoryPortletIndex]);
      }

      if (subCategoryPortletPath) {
        widgetPath = subCategoryPortletPath;
      }
    }

    return widgetPath;
  }
  /**
   * Iterates the widgets array recursively to set a given widget 'used' property
   * and returns a new array with the given widget modified
   */

  function setWidgetUsage(widgets, path, usage) {
    if (!path.length) {
      return _objectSpread({}, widgets, {
        used: usage.used
      });
    }

    var _path = _toArray(path),
        currentPath = _path[0],
        restPath = _path.slice(1);

    if (Array.isArray(widgets)) {
      return widgets.map(function (widget, index) {
        if (index === currentPath) {
          return setWidgetUsage(widgets[currentPath], restPath, usage);
        }

        return widget;
      });
    } else {
      return _objectSpread({}, widgets, _defineProperty({}, currentPath, setWidgetUsage(widgets[currentPath], restPath, usage)));
    }
  }
  //# sourceMappingURL=widgetsReducer.js.map
});
//# sourceMappingURL=widgetsReducer.js.map