Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/reducers/undoReducer", ['module', 'exports', 'require', '../actions/types', '../components/undo/undoActions'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = undoReducer;

  var _types = require("../actions/types");

  var _undoActions = require("../components/undo/undoActions");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var MAX_UNDO_ACTIONS = 20;

  function undoReducer(state, action) {
    switch (action.type) {
      case _types.ADD_UNDO_ACTION:
        {
          var actionType = action.actionType;
          var nextUndoHistory = state.undoHistory || [];
          return _objectSpread({}, state, {
            undoHistory: [(0, _undoActions.getDerivedStateForUndo)({
              action: action,
              state: state,
              type: actionType
            })].concat(_toConsumableArray(nextUndoHistory.slice(0, MAX_UNDO_ACTIONS - 1)))
          });
        }

      case _types.CLEAN_UNDO_ACTIONS:
        {
          var _nextUndoHistory = _toConsumableArray(state.undoHistory || []);

          var itemId = action.itemId;
          var item = state.layoutData.items[itemId];

          if (item.config && item.config.fragmentEntryLinkId) {
            _nextUndoHistory = _nextUndoHistory.filter(function (_ref) {
              var fragmentEntryLinkId = _ref.fragmentEntryLinkId;
              return fragmentEntryLinkId !== item.config.fragmentEntryLinkId;
            });
          }

          _nextUndoHistory = _nextUndoHistory.filter(function (_ref2) {
            var itemId = _ref2.itemId;
            return itemId !== action.itemId;
          });
          return _objectSpread({}, state, {
            undoHistory: _nextUndoHistory
          });
        }

      case _types.UPDATE_UNDO_ACTIONS:
        {
          return _objectSpread({}, state, {
            undoHistory: action.undoHistory
          });
        }

      default:
        return state;
    }
  }
  //# sourceMappingURL=undoReducer.js.map
});
//# sourceMappingURL=undoReducer.js.map