Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/reducers/fragmentsReducer", ['module', 'exports', 'require', '../actions/types'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = fragmentsReducer;

  var _types = require("../actions/types");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function fragmentsReducer() {
    var fragments = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    var action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case _types.ADD_FRAGMENT_COMPOSITION:
        {
          var composition = action.fragmentComposition;
          var existingCollection = fragments.find(function (collection) {
            return collection.fragmentCollectionId === composition.fragmentCollectionId;
          });
          var newCollection = existingCollection ? _objectSpread({}, existingCollection, {
            fragmentEntries: [].concat(_toConsumableArray(existingCollection.fragmentEntries), [composition])
          }) : {
            fragmentCollectionId: composition.fragmentCollectionId,
            fragmentEntries: [composition],
            name: composition.fragmentCollectionName
          };
          return [].concat(_toConsumableArray(fragments.filter(function (collection) {
            return collection.fragmentCollectionId !== newCollection.fragmentCollectionId;
          })), [newCollection]);
        }

      default:
        return fragments;
    }
  }
  //# sourceMappingURL=fragmentsReducer.js.map
});
//# sourceMappingURL=fragmentsReducer.js.map