Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/reducers/fragmentEntryLinksReducer", ['module', 'exports', 'require', '../actions/types'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = fragmentEntryLinksReducer;
  exports.INITIAL_STATE = void 0;

  var _types = require("../actions/types");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var INITIAL_STATE = {};
  exports.INITIAL_STATE = INITIAL_STATE;

  function fragmentEntryLinksReducer() {
    var fragmentEntryLinks = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : INITIAL_STATE;
    var action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case _types.ADD_FRAGMENT_ENTRY_LINKS:
        {
          var newFragmentEntryLinks = {};
          action.fragmentEntryLinks.forEach(function (fragmentEntryLink) {
            newFragmentEntryLinks[fragmentEntryLink.fragmentEntryLinkId] = fragmentEntryLink;
          });
          return _objectSpread({}, fragmentEntryLinks, {}, newFragmentEntryLinks);
        }

      case _types.ADD_FRAGMENT_ENTRY_LINK_COMMENT:
        {
          var fragmentEntryLink = fragmentEntryLinks[action.fragmentEntryLinkId];
          var _fragmentEntryLink$co = fragmentEntryLink.comments,
              comments = _fragmentEntryLink$co === void 0 ? [] : _fragmentEntryLink$co;
          var nextComments;

          if (action.parentCommentId) {
            nextComments = comments.map(function (comment) {
              return comment.commentId === action.parentCommentId ? _objectSpread({}, comment, {
                children: [].concat(_toConsumableArray(comment.children || []), [action.fragmentEntryLinkComment])
              }) : comment;
            });
          } else {
            nextComments = [].concat(_toConsumableArray(comments), [action.fragmentEntryLinkComment]);
          }

          return _objectSpread({}, fragmentEntryLinks, _defineProperty({}, action.fragmentEntryLinkId, _objectSpread({}, fragmentEntryLink, {
            comments: nextComments
          })));
        }

      case _types.DELETE_FRAGMENT_ENTRY_LINK_COMMENT:
        {
          var _fragmentEntryLink = fragmentEntryLinks[action.fragmentEntryLinkId];

          var _fragmentEntryLink$co2 = _fragmentEntryLink.comments,
              _comments = _fragmentEntryLink$co2 === void 0 ? [] : _fragmentEntryLink$co2;

          var _nextComments;

          if (action.parentCommentId) {
            _nextComments = _comments.map(function (comment) {
              return comment.commentId === action.parentCommentId ? _objectSpread({}, comment, {
                children: comment.children.filter(function (childComment) {
                  return childComment.commentId !== action.commentId;
                })
              }) : comment;
            });
          } else {
            _nextComments = _comments.filter(function (comment) {
              return comment.commentId !== action.commentId;
            });
          }

          return _objectSpread({}, fragmentEntryLinks, _defineProperty({}, action.fragmentEntryLinkId, _objectSpread({}, _fragmentEntryLink, {
            comments: _nextComments
          })));
        }

      case _types.DUPLICATE_ITEM:
        {
          var nextFragmentEntryLinks = _objectSpread({}, fragmentEntryLinks);

          action.addedFragmentEntryLinks.forEach(function (fragmentEntryLink) {
            nextFragmentEntryLinks[fragmentEntryLink.fragmentEntryLinkId] = fragmentEntryLink;
          });
          return nextFragmentEntryLinks;
        }

      case _types.EDIT_FRAGMENT_ENTRY_LINK_COMMENT:
        {
          var _fragmentEntryLink2 = fragmentEntryLinks[action.fragmentEntryLinkId];

          var _fragmentEntryLink2$c = _fragmentEntryLink2.comments,
              _comments2 = _fragmentEntryLink2$c === void 0 ? [] : _fragmentEntryLink2$c;

          var _nextComments2;

          if (action.parentCommentId) {
            _nextComments2 = _comments2.map(function (comment) {
              return comment.commentId === action.parentCommentId ? _objectSpread({}, comment, {
                children: comment.children.map(function (childComment) {
                  return childComment.commentId === action.fragmentEntryLinkComment.commentId ? action.fragmentEntryLinkComment : childComment;
                })
              }) : comment;
            });
          } else {
            _nextComments2 = _comments2.map(function (comment) {
              return comment.commentId === action.fragmentEntryLinkComment.commentId ? _objectSpread({}, comment, {}, action.fragmentEntryLinkComment) : comment;
            });
          }

          return _objectSpread({}, fragmentEntryLinks, _defineProperty({}, action.fragmentEntryLinkId, _objectSpread({}, _fragmentEntryLink2, {
            comments: _nextComments2
          })));
        }

      case _types.UPDATE_EDITABLE_VALUES:
        return _objectSpread({}, fragmentEntryLinks, _defineProperty({}, action.fragmentEntryLinkId, _objectSpread({}, fragmentEntryLinks[action.fragmentEntryLinkId], {
          editableValues: action.editableValues
        })));

      case _types.UPDATE_FRAGMENT_ENTRY_LINK_CONFIGURATION:
        return _objectSpread({}, fragmentEntryLinks, _defineProperty({}, action.fragmentEntryLinkId, action.fragmentEntryLink));

      case _types.UPDATE_FRAGMENT_ENTRY_LINK_CONTENT:
        {
          var _fragmentEntryLink3 = fragmentEntryLinks[action.fragmentEntryLinkId];
          var collectionContent = _fragmentEntryLink3.collectionContent || [];

          if (action.collectionItemIndex != null) {
            collectionContent = _toConsumableArray(collectionContent);
            collectionContent[action.collectionItemIndex] = action.content;
          }

          return _objectSpread({}, fragmentEntryLinks, _defineProperty({}, action.fragmentEntryLinkId, _objectSpread({}, fragmentEntryLinks[action.fragmentEntryLinkId], {
            collectionContent: collectionContent,
            content: action.content
          })));
        }

      case _types.UPDATE_LAYOUT_DATA:
        {
          var _nextFragmentEntryLinks = _objectSpread({}, fragmentEntryLinks);

          action.deletedFragmentEntryLinkIds.forEach(function (fragmentEntryLinkId) {
            delete _nextFragmentEntryLinks[fragmentEntryLinkId];
          });
          return _nextFragmentEntryLinks;
        }

      default:
        return fragmentEntryLinks;
    }
  }
  //# sourceMappingURL=fragmentEntryLinksReducer.js.map
});
//# sourceMappingURL=fragmentEntryLinksReducer.js.map