Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/reducers/collectionsReducer", ['module', 'exports', 'require', '../actions/types'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = collectionsReducer;

  var _types = require("../actions/types");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function collectionsReducer() {
    var collections = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    var action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case _types.ADD_FRAGMENT_COMPOSITION:
        {
          var composition = action.fragmentComposition;
          var existingCollection = collections.find(function (collection) {
            return collection.fragmentCollectionId === composition.fragmentCollectionId;
          });

          if (!existingCollection) {
            return [].concat(_toConsumableArray(collections), [{
              fragmentCollectionId: composition.fragmentCollectionId,
              name: composition.fragmentCollectionName
            }]);
          }

          return collections;
        }

      default:
        return collections;
    }
  }
  //# sourceMappingURL=collectionsReducer.js.map
});
//# sourceMappingURL=collectionsReducer.js.map