Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/processors/HTMLProcessor", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * @param {HTMLElement} element HTMLElement where the editor
   *  should be applied to.
   * @param {function} changeCallback Function that should be called whenever the
   *  editor produces a change. It must receive a string with
   *  the new editable value.
   * @param {function} destroyCallback Function that should be called if
   *  the editor is destroyed for any internal reason. This function does NOT need
   *  to be called if the editor is destroyed with destroyEditor function.
   */
  function createEditor(element, changeCallback, destroyCallback) {
    var dialog;
    var editor;
    Liferay.Util.openWindow({
      dialog: {
        after: {
          destroy: function destroy() {
            destroyCallback();
          }
        },
        constrain: true,
        cssClass: 'lfr-fulscreen-source-editor-dialog modal-full-screen',
        destroyOnHide: true,
        modal: true,
        'toolbars.footer': [{
          label: Liferay.Language.get('cancel'),
          on: {
            click: function click() {
              dialog.hide();
            }
          }
        }, {
          cssClass: 'btn-primary',
          label: Liferay.Language.get('save'),
          on: {
            click: function click() {
              var annotations = editor._editor.getSession().getAnnotations();

              var errorAnnotations = annotations.filter(function (annotation) {
                return annotation.type === 'error';
              });

              if (errorAnnotations.length) {
                var errorMessage = errorAnnotations.map(function (annotation) {
                  return annotation.text;
                }).join('\n');
                (0, _frontendJsWeb.openToast)({
                  message: errorMessage,
                  title: Liferay.Language.get('error'),
                  type: 'danger'
                });
              } else {
                changeCallback(editor.get('value'));
                dialog.hide();
              }
            }
          }
        }]
      },
      title: Liferay.Language.get('edit-content')
    }, function (_dialog) {
      dialog = _dialog;
      Liferay.Util.getTop().AUI().use('liferay-fullscreen-source-editor', function (A) {
        editor = new A.LiferayFullScreenSourceEditor({
          boundingBox: dialog.getStdModNode(A.WidgetStdMod.BODY).appendChild('<div></div>'),
          previewCssClass: 'alloy-editor alloy-editor-placeholder',
          value: element.innerHTML
        }).render();
      });
    });
  }
  /**
   */

  function destroyEditor() {}
  /**
   * @param {HTMLElement} element HTMLElement that should be mutated with the
   *  given value.
   * @param {string} value Element content
   */

  function render(element, value) {
    element.innerHTML = value;
  }

  var _default = {
    createEditor: createEditor,
    destroyEditor: destroyEditor,
    render: render
  };
  exports["default"] = _default;
  //# sourceMappingURL=HTMLProcessor.js.map
});
//# sourceMappingURL=HTMLProcessor.js.map