Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/undo/undoActions", ['module', 'exports', 'require', '../../../plugins/experience/actions', '../../actions/types', './undoDuplicateItem', './undoEditableValuesAction', './undoFragmentConfiguration', './undoFragmentEntryLinks', './undoLayoutDataAction', './undoSelectExperience', './undoUpdateLanguage'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.canUndoAction = canUndoAction;
  exports.getDerivedStateForUndo = getDerivedStateForUndo;
  exports.undoAction = undoAction;

  var _actions = require("../../../plugins/experience/actions");

  var _types = require("../../actions/types");

  var undoDuplicateItem = _interopRequireWildcard(require("./undoDuplicateItem"));

  var undoEditableValuesAction = _interopRequireWildcard(require("./undoEditableValuesAction"));

  var undoFragmentConfiguration = _interopRequireWildcard(require("./undoFragmentConfiguration"));

  var undoFragmentEntryLinks = _interopRequireWildcard(require("./undoFragmentEntryLinks"));

  var undoLayoutDataAction = _interopRequireWildcard(require("./undoLayoutDataAction"));

  var undoSelectExperience = _interopRequireWildcard(require("./undoSelectExperience"));

  var undoUpdateLanguage = _interopRequireWildcard(require("./undoUpdateLanguage"));

  var _UNDO_ACTIONS;

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var UNDO_ACTIONS = (_UNDO_ACTIONS = {}, _defineProperty(_UNDO_ACTIONS, _types.ADD_FRAGMENT_ENTRY_LINKS, undoFragmentEntryLinks), _defineProperty(_UNDO_ACTIONS, _types.ADD_ITEM, undoLayoutDataAction), _defineProperty(_UNDO_ACTIONS, _types.DUPLICATE_ITEM, undoDuplicateItem), _defineProperty(_UNDO_ACTIONS, _types.MOVE_ITEM, undoLayoutDataAction), _defineProperty(_UNDO_ACTIONS, _actions.SELECT_SEGMENTS_EXPERIENCE, undoSelectExperience), _defineProperty(_UNDO_ACTIONS, _types.UPDATE_COL_SIZE_START, undoLayoutDataAction), _defineProperty(_UNDO_ACTIONS, _types.UPDATE_EDITABLE_VALUES, undoEditableValuesAction), _defineProperty(_UNDO_ACTIONS, _types.UPDATE_FRAGMENT_ENTRY_LINK_CONFIGURATION, undoFragmentConfiguration), _defineProperty(_UNDO_ACTIONS, _types.UPDATE_ITEM_CONFIG, undoLayoutDataAction), _defineProperty(_UNDO_ACTIONS, _types.UPDATE_LANGUAGE_ID, undoUpdateLanguage), _UNDO_ACTIONS);

  function canUndoAction(action) {
    return Object.keys(UNDO_ACTIONS).includes(action.type) && !action.isUndo;
  }

  function getDerivedStateForUndo(_ref) {
    var action = _ref.action,
        state = _ref.state,
        type = _ref.type;
    var undoAction = UNDO_ACTIONS[type];
    return _objectSpread({}, undoAction.getDerivedStateForUndo({
      action: action,
      state: state
    }), {
      type: type
    });
  }

  function undoAction(_ref2) {
    var action = _ref2.action,
        store = _ref2.store;
    var type = action.type;
    var undoAction = UNDO_ACTIONS[type];
    return undoAction.undoAction({
      action: action,
      store: store
    });
  }
  //# sourceMappingURL=undoActions.js.map
});
//# sourceMappingURL=undoActions.js.map