Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/undo/Undo", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-js-react-web', 'frontend-js-metal-web$metal-dom', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../config/constants/keycodes', '../../store/index'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = Undo;

  var _button = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/button"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _keycodes = require("../../config/constants/keycodes");

  var _index = require("../../store/index");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var isTextElement = function isTextElement(element) {
    return element.tagName === 'INPUT' && element.type === 'text' || element.tagName === 'TEXTAREA';
  };

  var isCommentsAlloyEditor = function isCommentsAlloyEditor(element) {
    return element.classList.contains('alloy-editor') && element.parentElement.classList.contains('alloy-editor-container') && (0, _metalDom.closest)(element, '.page-editor__sidebar');
  };

  var isWithinIframe = function isWithinIframe() {
    return window.top !== window.self;
  };

  var isUndoCombination = function isUndoCombination(event) {
    return event.keyCode === _keycodes.Z_KEYCODE && (event.ctrlKey || event.metaKey);
  };

  function Undo(_ref) {
    var _ref$onRedo = _ref.onRedo,
        onRedo = _ref$onRedo === void 0 ? function () {} : _ref$onRedo,
        _ref$onUndo = _ref.onUndo,
        onUndo = _ref$onUndo === void 0 ? function () {} : _ref$onUndo;
    (0, _frontendJsReactWeb.useEventListener)('keydown', function (event) {
      if (isUndoCombination(event) && !isTextElement(event.target) && !isCommentsAlloyEditor(event.target) && !isWithinIframe()) {
        event.preventDefault();
        onUndo();
      }
    }, true, window);
    var undoHistory = (0, _index.useSelector)(function (state) {
      return state.undoHistory;
    });
    return _react["default"].createElement(_button["default"].Group, {
      className: "d-block d-none mr-3"
    }, _react["default"].createElement(_button.ClayButtonWithIcon, {
      "aria-label": Liferay.Language.get('undo'),
      className: "btn-monospaced",
      disabled: !undoHistory || !undoHistory.length,
      displayType: "secondary",
      onClick: onUndo,
      small: true,
      symbol: "undo",
      title: Liferay.Language.get('undo')
    }), _react["default"].createElement(_button.ClayButtonWithIcon, {
      "aria-label": Liferay.Language.get('redo'),
      className: "btn-monospaced",
      disabled: true,
      displayType: "secondary",
      onClick: onRedo,
      small: true,
      symbol: "redo",
      title: Liferay.Language.get('redo')
    }));
  }
  //# sourceMappingURL=Undo.js.map
});
//# sourceMappingURL=Undo.js.map