Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/layout-data-items/RowWithControls", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/modal', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../core/hooks/useSetRef', '../../../prop-types/index', '../../actions/types', '../../actions/updateColSize', '../../config/constants/layoutDataFloatingToolbarButtons', '../../config/constants/layoutDataItemDefaultConfigurations', '../../config/constants/layoutDataItemTypes', '../../store/index', '../../thunks/duplicateItem', '../../thunks/resizeColumns', '../../utils/getResponsiveConfig', '../Topper', '../floating-toolbar/FloatingToolbar', '../floating-toolbar/SaveFragmentCompositionModal', './ColumnOverlayGrid', './Row', './hasDropZoneChild'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.ResizingContext = void 0;

  var _modal = require("@frontend-taglib-clay$clayui/modal");

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _useSetRef3 = _interopRequireDefault(require("../../../core/hooks/useSetRef"));

  var _index = require("../../../prop-types/index");

  var _types = require("../../actions/types");

  var _updateColSize = _interopRequireDefault(require("../../actions/updateColSize"));

  var _layoutDataFloatingToolbarButtons = require("../../config/constants/layoutDataFloatingToolbarButtons");

  var _layoutDataItemDefaultConfigurations = require("../../config/constants/layoutDataItemDefaultConfigurations");

  var _layoutDataItemTypes = require("../../config/constants/layoutDataItemTypes");

  var _index2 = require("../../store/index");

  var _duplicateItem = _interopRequireDefault(require("../../thunks/duplicateItem"));

  var _resizeColumns = _interopRequireDefault(require("../../thunks/resizeColumns"));

  var _getResponsiveConfig = require("../../utils/getResponsiveConfig");

  var _Topper = _interopRequireDefault(require("../Topper"));

  var _FloatingToolbar = _interopRequireDefault(require("../floating-toolbar/FloatingToolbar"));

  var _SaveFragmentCompositionModal = _interopRequireDefault(require("../floating-toolbar/SaveFragmentCompositionModal"));

  var _ColumnOverlayGrid = _interopRequireDefault(require("./ColumnOverlayGrid"));

  var _Row = _interopRequireDefault(require("./Row"));

  var _hasDropZoneChild = _interopRequireDefault(require("./hasDropZoneChild"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var ResizingContext = _react["default"].createContext();

  exports.ResizingContext = ResizingContext;

  var RowWithControls = _react["default"].forwardRef(function (_ref, ref) {
    var children = _ref.children,
        item = _ref.item,
        layoutData = _ref.layoutData;
    var config = layoutData.items[item.itemId].config;
    var dispatch = (0, _index2.useDispatch)();

    var _LAYOUT_DATA_ITEM_DEF = _objectSpread({}, _layoutDataItemDefaultConfigurations.LAYOUT_DATA_ITEM_DEFAULT_CONFIGURATIONS[_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row], {}, item.config),
        gutters = _LAYOUT_DATA_ITEM_DEF.gutters;

    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        openSaveFragmentCompositionModal = _useState2[0],
        setOpenSaveFragmentCompositionModal = _useState2[1];

    var _useModal = (0, _modal.useModal)({
      onClose: function onClose() {
        if (isMounted()) {
          setOpenSaveFragmentCompositionModal(false);
        }
      }
    }),
        observer = _useModal.observer,
        onClose = _useModal.onClose;

    var segmentsExperienceId = (0, _index2.useSelector)(function (state) {
      return state.segmentsExperienceId;
    });
    var selectedViewportSize = (0, _index2.useSelector)(function (state) {
      return state.selectedViewportSize;
    });
    var rowConfig = (0, _getResponsiveConfig.getResponsiveConfig)(config, selectedViewportSize);

    var _useSetRef = (0, _useSetRef3["default"])(ref),
        _useSetRef2 = _slicedToArray(_useSetRef, 2),
        setRef = _useSetRef2[0],
        itemElement = _useSetRef2[1];

    var rowRect = getRect(itemElement);

    var _useState3 = (0, _react.useState)(null),
        _useState4 = _slicedToArray(_useState3, 2),
        highlightedColumn = _useState4[0],
        setHighLightedColumn = _useState4[1];

    var _useState5 = (0, _react.useState)(false),
        _useState6 = _slicedToArray(_useState5, 2),
        resizeFinished = _useState6[0],
        setResizeFinished = _useState6[1];

    var _useState7 = (0, _react.useState)(false),
        _useState8 = _slicedToArray(_useState7, 2),
        showOverlay = _useState8[0],
        setShowOverlay = _useState8[1];

    var handleButtonClick = (0, _react.useCallback)(function (id) {
      if (id === _layoutDataFloatingToolbarButtons.LAYOUT_DATA_FLOATING_TOOLBAR_BUTTONS.duplicateItem.id) {
        dispatch((0, _duplicateItem["default"])({
          itemId: item.itemId,
          segmentsExperienceId: segmentsExperienceId
        }));
      } else if (id === _layoutDataFloatingToolbarButtons.LAYOUT_DATA_FLOATING_TOOLBAR_BUTTONS.saveFragmentComposition.id) {
        setOpenSaveFragmentCompositionModal(true);
      }
    }, [dispatch, item.itemId, segmentsExperienceId]);

    var getHighlightedColumnIndex = function getHighlightedColumnIndex(clientX) {
      var gridSizes = getGridSizes(rowRect.width);
      var mousePosition = clientX - rowRect.left;
      return getClosestGridIndexPosition(mousePosition, gridSizes);
    };

    (0, _react.useEffect)(function () {
      if (resizeFinished) {
        setResizeFinished(false);
        dispatch((0, _resizeColumns["default"])({
          layoutData: layoutData,
          segmentsExperienceId: segmentsExperienceId
        }));
      }
    }, [layoutData, dispatch, resizeFinished, segmentsExperienceId]);
    var buttons = [];

    if (!(0, _hasDropZoneChild["default"])(item, layoutData)) {
      buttons.push(_layoutDataFloatingToolbarButtons.LAYOUT_DATA_FLOATING_TOOLBAR_BUTTONS.duplicateItem);
      buttons.push(_layoutDataFloatingToolbarButtons.LAYOUT_DATA_FLOATING_TOOLBAR_BUTTONS.saveFragmentComposition);
    }

    buttons.push(_layoutDataFloatingToolbarButtons.LAYOUT_DATA_FLOATING_TOOLBAR_BUTTONS.rowConfiguration);
    var verticalAlignment = rowConfig.verticalAlignment;
    return _react["default"].createElement(_Topper["default"], {
      item: item,
      itemElement: itemElement,
      layoutData: layoutData
    }, _react["default"].createElement(_Row["default"], {
      className: (0, _classnames["default"])('page-editor__row', {
        'align-bottom': verticalAlignment === 'bottom',
        'align-middle': verticalAlignment === 'middle'
      }),
      item: item,
      layoutData: layoutData,
      ref: setRef
    }, _react["default"].createElement(_FloatingToolbar["default"], {
      buttons: buttons,
      item: item,
      itemElement: itemElement,
      onButtonClick: handleButtonClick
    }), _react["default"].createElement(ResizingContext.Provider, {
      value: {
        onResizeEnd: function onResizeEnd() {
          setHighLightedColumn(null);
          setShowOverlay(false);
          setResizeFinished(true);
        },
        onResizeStart: function onResizeStart(_ref2) {
          var clientX = _ref2.clientX;
          dispatch({
            itemId: item.itemId,
            type: _types.UPDATE_COL_SIZE_START
          });
          setHighLightedColumn(getHighlightedColumnIndex(clientX));
          setShowOverlay(true);
        },
        onResizing: function onResizing(_ref3, columnInfo) {
          var clientX = _ref3.clientX;

          if (itemElement) {
            var index = getHighlightedColumnIndex(clientX);
            setHighLightedColumn(index);
            var columnSizes = getColumnAccumulationSizes(item.children, layoutData);
            var colIndex = columnInfo.colIndex,
                currentColumn = columnInfo.currentColumn,
                currentColumnConfig = columnInfo.currentColumnConfig,
                nextColumn = columnInfo.nextColumn,
                nextColumnIndex = columnInfo.nextColumnIndex;
            var currentRange = columnSizes[colIndex];
            var nextRange = columnSizes[nextColumnIndex];
            var addedIndex = index + 1;
            var newCurrentSize = currentColumnConfig.size + (addedIndex - currentRange);
            var newNextSize = nextRange - addedIndex;

            if (newCurrentSize >= 1 && newNextSize >= 1) {
              dispatch((0, _updateColSize["default"])({
                itemId: currentColumn.itemId,
                nextColumnItemId: nextColumn.itemId,
                nextColumnSize: newNextSize,
                size: newCurrentSize
              }));
            }
          }
        }
      }
    }, children, showOverlay && _react["default"].createElement(_ColumnOverlayGrid["default"], {
      columnSpacing: gutters,
      highlightedColumn: highlightedColumn,
      rowRect: rowRect
    })), openSaveFragmentCompositionModal && _react["default"].createElement(_SaveFragmentCompositionModal["default"], {
      errorMessage: '',
      itemId: item.itemId,
      observer: observer,
      onClose: onClose,
      onErrorDismiss: function onErrorDismiss() {
        return true;
      }
    })));
  });

  var _default = RowWithControls;
  exports["default"] = _default;
  var TOTAL_NUMBER_OF_COLUMNS = 12;
  /**
   * Generates an array containing the current width of each column on the grid of 12.
   * For example, for a column width of 100, the result will be:
   *
   * > [100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 1100, 1200]
   *
   * @param {!Number} The starting colWidth.
   *
   * @returns{!Array<number>}
   */

  function getGridRanges(colWidth) {
    return _toConsumableArray(Array(TOTAL_NUMBER_OF_COLUMNS).keys()).reduce(function (acc, current, index) {
      if (index === 0) {
        return acc;
      }

      return [].concat(_toConsumableArray(acc), [acc[current - 1] + colWidth]);
    }, [colWidth]);
  }
  /**
   * Returns an accumulative array of sizes.
   * For example, for a Row containing 3 columns sizing `4`:
   * The result is [4, 8, 12]. This result indicates the grid position of each column end.
   *
   * @param {!Array<String>} A rowChildren array, that contains the related itemId of each Row child.
   * @param {!Object} The current value of layoutData from store.
   *
   * @returns {!Array<number>}
   */

  function getColumnAccumulationSizes(rowChildren, layoutData) {
    return rowChildren.reduce(function (acc, currentId, index) {
      if (index === 0) {
        return acc;
      }

      return [].concat(_toConsumableArray(acc), [acc[index - 1] + layoutData.items[currentId].config.size]);
    }, [layoutData.items[rowChildren[0]].config.size]);
  }
  /**
   * Calculates the current Grid position when receiving a mousePosition.
   *
   * @param {!Number} Current mousePosition from mousemove event.
   * @param {!Number} The index of the current hovered grid.
   */

  function getClosestGridIndexPosition(mousePosition, gridSizes) {
    var closest = gridSizes.reduce(function (prev, curr) {
      return Math.abs(curr - mousePosition) < Math.abs(prev - mousePosition) ? curr : prev;
    });
    return gridSizes.indexOf(closest);
  }
  /**
   * Receives the current Row OffsetWidth and calls `getGridRanges`.
   * @param {!Number} Row's OffsetWidth
   *
   * @returns {!Array}
   */

  function getGridSizes(rowOffsetWidth) {
    var colWidth = Math.floor(rowOffsetWidth / TOTAL_NUMBER_OF_COLUMNS);
    return getGridRanges(colWidth);
  }
  /**
   *
   * @param {!Element} An element
   *
   * @returns {!DOMRect} The DOMRect of the given element.
   */

  function getRect(element) {
    if (!element) {
      return {
        bottom: 0,
        height: 0,
        left: 0,
        right: 0,
        top: 0,
        width: 0
      };
    }

    return element.getBoundingClientRect();
  }
  //# sourceMappingURL=RowWithControls.js.map
});
//# sourceMappingURL=RowWithControls.js.map