Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/layout-data-items/Row", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../prop-types/index', '../../config/constants/layoutDataItemTypes', '../../store/index', '../../utils/getResponsiveConfig'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _index = require("../../../prop-types/index");

  var _layoutDataItemTypes = require("../../config/constants/layoutDataItemTypes");

  var _index2 = require("../../store/index");

  var _getResponsiveConfig = require("../../utils/getResponsiveConfig");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var Row = _react["default"].forwardRef(function (_ref, ref) {
    var children = _ref.children,
        className = _ref.className,
        item = _ref.item,
        layoutData = _ref.layoutData;
    var selectedViewportSize = (0, _index2.useSelector)(function (state) {
      return state.selectedViewportSize;
    });
    var itemConfig = (0, _getResponsiveConfig.getResponsiveConfig)(item.config, selectedViewportSize);
    var modulesPerRow = itemConfig.modulesPerRow,
        reverseOrder = itemConfig.reverseOrder;

    var rowContent = _react["default"].createElement("div", {
      className: (0, _classnames["default"])(className, 'row', {
        empty: item.config.numberOfColumns === modulesPerRow && !item.children.some(function (childId) {
          return layoutData.items[childId].children.length;
        }),
        'flex-column': modulesPerRow === 1,
        'flex-column-reverse': item.config.numberOfColumns === 2 && modulesPerRow === 1 && reverseOrder,
        'no-gutters': !item.config.gutters
      }),
      ref: ref
    }, children);

    var masterLayoutData = (0, _index2.useSelector)(function (state) {
      return state.masterLayoutData;
    });
    var masterParent = (0, _react.useMemo)(function () {
      var dropZone = masterLayoutData && masterLayoutData.items[masterLayoutData.rootItems.dropZone];
      return dropZone ? getItemParent(dropZone, masterLayoutData) : undefined;
    }, [masterLayoutData]);
    var shouldAddContainer = (0, _index2.useSelector)(function (state) {
      return !getItemParent(item, state.layoutData) && !masterParent;
    });
    return shouldAddContainer ? _react["default"].createElement("div", {
      className: "container-fluid p-0"
    }, rowContent) : rowContent;
  });

  function getItemParent(item, itemLayoutData) {
    var parent = itemLayoutData.items[item.parentId];
    return parent && (parent.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.root || parent.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragmentDropZone) ? getItemParent(parent, itemLayoutData) : parent;
  }

  var _default = Row;
  exports["default"] = _default;
  //# sourceMappingURL=Row.js.map
});
//# sourceMappingURL=Row.js.map