Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/layout-data-items/ColumnWithControls", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../prop-types/index', '../Controls', '../TopperEmpty', './Column', './RowWithControls'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _index = require("../../../prop-types/index");

  var _Controls = require("../Controls");

  var _TopperEmpty = _interopRequireDefault(require("../TopperEmpty"));

  var _Column = _interopRequireDefault(require("./Column"));

  var _RowWithControls = require("./RowWithControls");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var ColumnWithControls = _react["default"].forwardRef(function (_ref, ref) {
    var children = _ref.children,
        item = _ref.item,
        layoutData = _ref.layoutData;
    var isActive = (0, _Controls.useIsActive)();
    var parentItemIsActive = (0, _react.useMemo)(function () {
      return layoutData.items[item.parentId] ? isActive(item.parentId) : false;
    }, [isActive, item, layoutData]);

    var _useContext = (0, _react.useContext)(_RowWithControls.ResizingContext),
        onResizeEnd = _useContext.onResizeEnd,
        onResizeStart = _useContext.onResizeStart,
        onResizing = _useContext.onResizing;

    var columnInfo = (0, _react.useMemo)(function () {
      return getColumnInfo({
        item: item,
        layoutData: layoutData
      });
    }, [item, layoutData]);

    var onWindowMouseMove = function onWindowMouseMove(event) {
      event.preventDefault();
      onResizing(event, columnInfo);
    };

    var onWindowMouseUp = function onWindowMouseUp(event) {
      onResizeEnd(event);
      window.removeEventListener('mouseup', onWindowMouseUp);
      window.removeEventListener('mousemove', onWindowMouseMove);
    };

    (0, _react.useEffect)(function () {
      return function () {
        window.removeEventListener('mouseup', onWindowMouseUp);
        window.removeEventListener('mousemove', onWindowMouseMove);
      };
    }, // We just want to ensure that this listeners are removed if
    // the component is unmounted before resizing has ended
    // eslint-disable-next-line react-hooks/exhaustive-deps
    []);
    return _react["default"].createElement(_TopperEmpty["default"], {
      item: item,
      layoutData: layoutData
    }, _react["default"].createElement(_Column["default"], {
      className: "page-editor__col",
      item: item,
      ref: ref
    }, parentItemIsActive && !columnInfo.isLastColumn ? _react["default"].createElement("div", null, children, _react["default"].createElement("button", {
      className: "btn-primary page-editor__col__resizer",
      onMouseDown: function onResizeButtonMouseDown(event) {
        onResizeStart(event);
        window.addEventListener('mouseup', onWindowMouseUp);
        window.addEventListener('mousemove', onWindowMouseMove);
      }
    })) : children));
  });

  var _default = ColumnWithControls;
  /**
   * Retrieves necessary data from the current and next column.
   *
   * @param {!Object} options
   * @param {!Object} options.item
   * @param {!Object} options.layoutData
   *
   * @returns {!Object}
   */

  exports["default"] = _default;

  function getColumnInfo(_ref2) {
    var item = _ref2.item,
        layoutData = _ref2.layoutData;
    var rowColumns = layoutData.items[item.parentId].children;
    var colIndex = rowColumns.indexOf(item.itemId);

    var currentColumn = item;
    var currentColumnConfig = currentColumn.config;

    var nextColumn = _objectSpread({}, layoutData.items[rowColumns[colIndex + 1]]);

    var nextColumnConfig = _typeof(nextColumn) === 'object' && Object.keys(nextColumn).length ? nextColumn.config : {};
    return {
      colIndex: colIndex,
      currentColumn: currentColumn,
      currentColumnConfig: currentColumnConfig,
      isLastColumn: rowColumns.indexOf(item.itemId) === rowColumns.length - 1,
      nextColumn: nextColumn ? nextColumn : {},
      nextColumnConfig: nextColumn ? nextColumnConfig : {},
      nextColumnIndex: colIndex + 1,
      rowColumns: rowColumns
    };
  }
  //# sourceMappingURL=ColumnWithControls.js.map
});
//# sourceMappingURL=ColumnWithControls.js.map