Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/layout-data-items/Collection", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../services/CollectionService', '../../store/index', '../CollectionItemContext'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.getToControlsId = getToControlsId;
  exports.fromControlsId = fromControlsId;
  exports["default"] = void 0;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _CollectionService = _interopRequireDefault(require("../../services/CollectionService"));

  var _index = require("../../store/index");

  var _CollectionItemContext = require("../CollectionItemContext");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var COLLECTION_ID_DIVIDER = '$';

  function collectionIsMapped(collectionConfig) {
    return collectionConfig.collection;
  }

  function getCollectionPrefix(collectionId, index) {
    return "collection-".concat(collectionId, "-").concat(index).concat(COLLECTION_ID_DIVIDER);
  }

  function getToControlsId(collectionId, index) {
    return function (itemId) {
      if (!itemId) {
        return null;
      }

      return "".concat(getCollectionPrefix(collectionId, index)).concat(itemId);
    };
  }

  function fromControlsId(controlsItemId) {
    if (!controlsItemId) {
      return null;
    }

    var _controlsItemId$split = controlsItemId.split(COLLECTION_ID_DIVIDER),
        _controlsItemId$split2 = _slicedToArray(_controlsItemId$split, 2),
        itemId = _controlsItemId$split2[1];

    return itemId || controlsItemId;
  }

  var NoItemsMessage = function NoItemsMessage() {
    return _react["default"].createElement("div", {
      className: "page-editor__collection__no-items-message"
    }, Liferay.Language.get('you-do-not-have-any-items-in-this-collection'));
  };

  var NotCollectionSelectedMessage = function NotCollectionSelectedMessage() {
    return _react["default"].createElement("div", {
      className: "page-editor__collection__not-collection-selected-message"
    }, Liferay.Language.get('no-collection-selected-yet'));
  };

  var Grid = function Grid(_ref) {
    var child = _ref.child,
        collection = _ref.collection,
        collectionFields = _ref.collectionFields,
        collectionId = _ref.collectionId,
        collectionLength = _ref.collectionLength,
        numberOfColumns = _ref.numberOfColumns,
        numberOfItems = _ref.numberOfItems;
    var maxNumberOfItems = Math.min(collectionLength, numberOfItems);
    var numberOfRows = Math.ceil(maxNumberOfItems / numberOfColumns);

    return function createRows() {
      var rows = [];

      for (var i = 0; i < numberOfRows; i++) {
        var columns = [];

        for (var j = 0; j < numberOfColumns; j++) {
          var index = [i, j].join('-');
          var itemCount = i * numberOfColumns + j;
          columns.push(_react["default"].createElement("div", {
            className: "col col-".concat(12 / numberOfColumns),
            key: index
          }, itemCount < maxNumberOfItems && _react["default"].createElement(_CollectionItemContext.CollectionItemContextProvider, {
            key: index,
            value: {
              collectionFields: collectionFields,
              collectionItem: collection[i * numberOfColumns + j],
              collectionItemIndex: i * numberOfColumns + j,
              fromControlsId: itemCount === 0 ? null : fromControlsId,
              toControlsId: itemCount === 0 ? null : getToControlsId(collectionId, index)
            }
          }, _react["default"].cloneElement(child))));
        }

        rows.push(_react["default"].createElement("div", {
          className: "row",
          key: i
        }, columns));
      }

      return rows;
    }();
  };

  var Collection = _react["default"].forwardRef(function (_ref2, ref) {
    var children = _ref2.children,
        item = _ref2.item;

    var child = _react["default"].Children.toArray(children)[0];

    var collectionConfig = item.config;
    var dispatch = (0, _index.useDispatch)();
    var segmentsExperienceId = (0, _index.useSelector)(function (state) {
      return state.segmentsExperienceId;
    });

    var _useState = (0, _react.useState)({
      items: [],
      length: 0
    }),
        _useState2 = _slicedToArray(_useState, 2),
        collection = _useState2[0],
        setCollection = _useState2[1];

    (0, _react.useEffect)(function () {
      if (collectionConfig.collection) {
        _CollectionService["default"].getCollectionField({
          collection: collectionConfig.collection,
          onNetworkStatus: dispatch,
          segmentsExperienceId: segmentsExperienceId,
          size: collectionConfig.numberOfItems
        }).then(function (response) {
          setCollection(response);
        })["catch"](function (error) {});
      }
    }, [collectionConfig.collection, collectionConfig.numberOfItems, dispatch, segmentsExperienceId]);

    var _useState3 = (0, _react.useState)([]),
        _useState4 = _slicedToArray(_useState3, 2),
        collectionFields = _useState4[0],
        setCollectionFields = _useState4[1];

    (0, _react.useEffect)(function () {
      if (collectionConfig.collection) {
        _CollectionService["default"].getCollectionMappingFields({
          itemSubtype: collectionConfig.collection.itemSubtype || '',
          itemType: collectionConfig.collection.itemType,
          onNetworkStatus: dispatch
        }).then(function (response) {
          setCollectionFields(response);
        })["catch"](function (error) {});
      }
    }, [dispatch, collectionConfig.collection]);
    return _react["default"].createElement("div", {
      className: "page-editor__collection",
      ref: ref
    }, collectionIsMapped(collectionConfig) && collection.items.length > 0 ? _react["default"].createElement(Grid, {
      child: child,
      collection: collection.items,
      collectionFields: collectionFields,
      collectionId: item.itemId,
      collectionLength: collection.items.length,
      numberOfColumns: collectionConfig.numberOfColumns,
      numberOfItems: collectionConfig.numberOfItems
    }) : collectionIsMapped(collectionConfig) ? _react["default"].createElement(NoItemsMessage, null) : _react["default"].createElement(NotCollectionSelectedMessage, null));
  });

  var _default = Collection;
  exports["default"] = _default;
  //# sourceMappingURL=Collection.js.map
});
//# sourceMappingURL=Collection.js.map