Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/fragment-content/FragmentContentProcessor", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../config/index', '../../selectors/selectSegmentsExperienceId', '../../store/index', '../../thunks/updateEditableValues', './EditableProcessorContext', './getEditableUniqueId'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = FragmentContentProcessor;

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = require("frontend-js-react-web$react");

  var _index = require("../../config/index");

  var _selectSegmentsExperienceId = _interopRequireDefault(require("../../selectors/selectSegmentsExperienceId"));

  var _index2 = require("../../store/index");

  var _updateEditableValues = _interopRequireDefault(require("../../thunks/updateEditableValues"));

  var _EditableProcessorContext = require("./EditableProcessorContext");

  var _getEditableUniqueId = _interopRequireDefault(require("./getEditableUniqueId"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function FragmentContentProcessor(_ref) {
    var editables = _ref.editables,
        fragmentEntryLinkId = _ref.fragmentEntryLinkId;
    var dispatch = (0, _index2.useDispatch)();
    var editableProcessorClickPosition = (0, _EditableProcessorContext.useEditableProcessorClickPosition)();
    var editableProcessorUniqueId = (0, _EditableProcessorContext.useEditableProcessorUniqueId)();
    var setEditableProcessorUniqueId = (0, _EditableProcessorContext.useSetEditableProcessorUniqueId)();
    var isProcessorEnabled = (0, _EditableProcessorContext.useIsProcessorEnabled)();
    var languageId = (0, _index2.useSelector)(function (state) {
      return state.languageId || _index.config.defaultLanguageId;
    });
    var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId["default"]);
    var editable = (0, _react.useMemo)(function () {
      var enabledEditable = {
        editableId: null,
        editableValueNamespace: null,
        element: null,
        processor: null
      };

      if (editables) {
        enabledEditable = editables.find(function (editable) {
          return isProcessorEnabled((0, _getEditableUniqueId["default"])(fragmentEntryLinkId, editable.editableId));
        }) || enabledEditable;
      }

      return enabledEditable;
    }, [editables, isProcessorEnabled, fragmentEntryLinkId]);
    var editableValues = (0, _index2.useSelector)(function (state) {
      return state.fragmentEntryLinks[fragmentEntryLinkId] && state.fragmentEntryLinks[fragmentEntryLinkId].editableValues;
    });
    (0, _react.useEffect)(function () {
      if (!editable.element || !editableValues) {
        return;
      }

      var editableValue = editableValues[editable.editableValueNamespace][editable.editableId];
      editable.processor.createEditor(editable.element, function (value) {
        var previousValue = editableValue[languageId];

        if (!previousValue && value === editableValue.defaultValue.trim()) {
          return;
        }

        if (previousValue === value) {
          return;
        }

        var nextEditableValue = _objectSpread({}, editableValue);

        nextEditableValue = _objectSpread({}, nextEditableValue, _defineProperty({}, languageId, value));
        dispatch((0, _updateEditableValues["default"])({
          editableValues: _objectSpread({}, editableValues, _defineProperty({}, editable.editableValueNamespace, _objectSpread({}, editableValues[editable.editableValueNamespace], _defineProperty({}, editable.editableId, nextEditableValue)))),
          fragmentEntryLinkId: fragmentEntryLinkId,
          segmentsExperienceId: segmentsExperienceId
        }));
      }, function () {
        editable.processor.destroyEditor(editable.element, editableValue.config);
        setEditableProcessorUniqueId(null);
      }, editableProcessorClickPosition);
      return function () {
        if (!editableProcessorUniqueId) {
          editable.processor.destroyEditor(editable.element, editableValue.config);
        }
      };
    }, [dispatch, editable.editableId, editable.editableValueNamespace, editable.element, editable.processor, editableProcessorClickPosition, editableProcessorUniqueId, editableValues, fragmentEntryLinkId, languageId, segmentsExperienceId, setEditableProcessorUniqueId]);
    return null;
  }

  FragmentContentProcessor.propTypes = {
    editables: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      editableId: _propTypes["default"].string.isRequired,
      editableValueNamespace: _propTypes["default"].string.isRequired,
      element: _propTypes["default"].object.isRequired,
      processor: _propTypes["default"].object
    })),
    fragmentEntryLinkId: _propTypes["default"].string.isRequired
  };
  //# sourceMappingURL=FragmentContentProcessor.js.map
});
//# sourceMappingURL=FragmentContentProcessor.js.map