Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/fragment-content/FragmentContentInteractionsFilter", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../config/constants/editableFragmentEntryProcessor', '../../config/constants/itemActivationOrigins', '../../config/constants/itemTypes', '../../config/index', '../../selectors/selectCanUpdate', '../../selectors/selectCanUpdateLayoutContent', '../../store/index', '../Controls', './EditableProcessorContext', './getEditableElement', './getEditableElementId', './getEditableUniqueId', './isMapped'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = FragmentContentInteractionsFilter;

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _editableFragmentEntryProcessor = require("../../config/constants/editableFragmentEntryProcessor");

  var _itemActivationOrigins = require("../../config/constants/itemActivationOrigins");

  var _itemTypes = require("../../config/constants/itemTypes");

  var _index = require("../../config/index");

  var _selectCanUpdate = _interopRequireDefault(require("../../selectors/selectCanUpdate"));

  var _selectCanUpdateLayoutContent = _interopRequireDefault(require("../../selectors/selectCanUpdateLayoutContent"));

  var _index2 = require("../../store/index");

  var _Controls = require("../Controls");

  var _EditableProcessorContext = require("./EditableProcessorContext");

  var _getEditableElement = require("./getEditableElement");

  var _getEditableElementId = _interopRequireDefault(require("./getEditableElementId"));

  var _getEditableUniqueId = _interopRequireDefault(require("./getEditableUniqueId"));

  var _isMapped = _interopRequireDefault(require("./isMapped"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  var EDITABLE_CLASS_NAMES = {
    active: 'page-editor__editable--active',
    hovered: 'page-editor__editable--hovered',
    mapped: 'page-editor__editable--mapped',
    translated: 'page-editor__editable--translated'
  };

  var isTranslated = function isTranslated(defaultLanguageId, languageId, editableValue) {
    return defaultLanguageId !== languageId && editableValue[languageId];
  };

  function FragmentContentInteractionsFilter(_ref) {
    var children = _ref.children,
        editableElements = _ref.editableElements,
        fragmentEntryLinkId = _ref.fragmentEntryLinkId,
        itemId = _ref.itemId;
    var activationOrigin = (0, _Controls.useActivationOrigin)();
    var hoverItem = (0, _Controls.useHoverItem)();
    var isActive = (0, _Controls.useIsActive)();
    var isHovered = (0, _Controls.useIsHovered)();
    var activeItemId = (0, _Controls.useActiveItemId)();
    var activeItemType = (0, _Controls.useActiveItemType)();
    var hoveredItemId = (0, _Controls.useHoveredItemId)();
    var hoveredItemType = (0, _Controls.useHoveredItemType)();
    var selectItem = (0, _Controls.useSelectItem)();
    var setEditableProcessorUniqueId = (0, _EditableProcessorContext.useSetEditableProcessorUniqueId)();
    var canUpdateLayoutContent = (0, _index2.useSelector)(_selectCanUpdateLayoutContent["default"]);
    var canUpdate = (0, _index2.useSelector)(_selectCanUpdate["default"]);
    var languageId = (0, _index2.useSelector)(function (state) {
      return state.languageId;
    });

    var editableValues = (0, _index2.useSelector)(function (state) {
      return state.fragmentEntryLinks[fragmentEntryLinkId] ? state.fragmentEntryLinks[fragmentEntryLinkId].editableValues[_editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR] : {};
    });
    var siblingIds = (0, _react.useMemo)(function () {
      return [itemId].concat(_toConsumableArray(editableElements.map(function (editableElement) {
        return (0, _getEditableUniqueId["default"])(fragmentEntryLinkId, (0, _getEditableElementId["default"])(editableElement));
      })));
    }, [itemId, editableElements, fragmentEntryLinkId]);
    (0, _react.useEffect)(function () {
      editableElements.forEach(function (editableElement) {
        if (editableValues) {
          var editableValue = editableValues[(0, _getEditableElementId["default"])(editableElement)];

          if ((0, _isMapped["default"])(editableValue)) {
            editableElement.classList.add(EDITABLE_CLASS_NAMES.mapped);
          } else if (isTranslated(_index.config.defaultLanguageId, languageId, editableValue)) {
            editableElement.classList.add(EDITABLE_CLASS_NAMES.translated);
          } else {
            editableElement.classList.remove(EDITABLE_CLASS_NAMES.mapped);
            editableElement.classList.remove(EDITABLE_CLASS_NAMES.translated);
          }
        }
      });
    }, [editableElements, editableValues, languageId]);
    (0, _react.useEffect)(function () {
      editableElements.forEach(function (editableElement) {
        var editableUniqueId = (0, _getEditableUniqueId["default"])(fragmentEntryLinkId, (0, _getEditableElementId["default"])(editableElement));

        if (isActive(editableUniqueId)) {
          editableElement.classList.add(EDITABLE_CLASS_NAMES.active);
        } else {
          editableElement.classList.remove(EDITABLE_CLASS_NAMES.active);
        }
      });
    }, [activeItemId, editableElements, fragmentEntryLinkId, isActive]);
    (0, _react.useEffect)(function () {
      editableElements.forEach(function (editableElement) {
        if (editableValues) {
          var editableValue = editableValues[(0, _getEditableElementId["default"])(editableElement)];
          var editableUniqueId = (0, _getEditableUniqueId["default"])(fragmentEntryLinkId, (0, _getEditableElementId["default"])(editableElement));
          var hovered = false;

          if (hoveredItemType === _itemTypes.ITEM_TYPES.mappedContent && "".concat(editableValue.classNameId, "-").concat(editableValue.classPK) === hoveredItemId) {
            hovered = true;
          } else if (siblingIds.some(isActive) && isHovered(editableUniqueId)) {
            hovered = true;
          }

          if (hovered) {
            editableElement.classList.add(EDITABLE_CLASS_NAMES.hovered);
          } else {
            editableElement.classList.remove(EDITABLE_CLASS_NAMES.hovered);
          }
        }
      });
    }, [editableElements, editableValues, fragmentEntryLinkId, hoveredItemId, hoveredItemType, isActive, isHovered, itemId, siblingIds]);
    (0, _react.useEffect)(function () {
      var activeEditableElement;

      var enableProcessor = function enableProcessor(event) {
        var editableElement = (0, _getEditableElement.getEditableElement)(event.target);

        if (editableElement) {
          var editableElementId = (0, _getEditableElementId["default"])(editableElement);
          var editableValue = editableValues[editableElementId] || {};

          if ((0, _isMapped["default"])(editableValue)) {
            return;
          }

          var editableClickPosition = {
            clientX: event.clientX,
            clientY: event.clientY
          };
          var editableUniqueId = (0, _getEditableUniqueId["default"])(fragmentEntryLinkId, (0, _getEditableElementId["default"])(editableElement));

          if (isActive(editableUniqueId)) {
            setEditableProcessorUniqueId(editableUniqueId, editableClickPosition);
          }
        }
      };

      if (activeItemId && activeItemType === _itemTypes.ITEM_TYPES.editable) {
        activeEditableElement = editableElements.find(function (editableElement) {
          return isActive((0, _getEditableUniqueId["default"])(fragmentEntryLinkId, (0, _getEditableElementId["default"])(editableElement)));
        });

        if (activeEditableElement) {
          if (canUpdateLayoutContent) {
            requestAnimationFrame(function () {
              activeEditableElement.addEventListener('dblclick', enableProcessor);
            });
          }

          if (activationOrigin === _itemActivationOrigins.ITEM_ACTIVATION_ORIGINS.structureTree) {
            activeEditableElement.scrollIntoView({
              behavior: 'smooth',
              block: 'center',
              inline: 'nearest'
            });
          }
        }
      }

      return function () {
        if (activeEditableElement) {
          activeEditableElement.removeEventListener('dblclick', enableProcessor);
        }
      };
    }, [activationOrigin, activeItemId, activeItemType, canUpdateLayoutContent, editableElements, editableValues, fragmentEntryLinkId, isActive, itemId, setEditableProcessorUniqueId]);

    var hoverEditable = function hoverEditable(event) {
      var editableElement = (0, _getEditableElement.getEditableElement)(event.target);

      if (editableElement) {
        event.stopPropagation();
        hoverItem((0, _getEditableUniqueId["default"])(fragmentEntryLinkId, (0, _getEditableElementId["default"])(editableElement)), {
          itemType: _itemTypes.ITEM_TYPES.editable
        });
      }
    };

    var selectEditable = function selectEditable(event) {
      var editableElement = (0, _getEditableElement.getEditableElement)(event.target);

      if (editableElement) {
        event.stopPropagation();
        var editableUniqueId = (0, _getEditableUniqueId["default"])(fragmentEntryLinkId, (0, _getEditableElementId["default"])(editableElement));

        if (isActive(editableUniqueId)) {
          event.stopPropagation();
        } else {
          selectItem(editableUniqueId, {
            itemType: _itemTypes.ITEM_TYPES.editable
          });
        }
      }
    };

    var props = {};

    if (siblingIds.some(isActive) || !canUpdate && canUpdateLayoutContent) {
      props.onClickCapture = selectEditable;
      props.onMouseOverCapture = hoverEditable;
    }

    return _react["default"].createElement("div", props, children);
  }
  //# sourceMappingURL=FragmentContentInteractionsFilter.js.map
});
//# sourceMappingURL=FragmentContentInteractionsFilter.js.map