Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/fragment-content/FragmentContentFloatingToolbar", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../config/constants/editableFloatingToolbarButtons', '../../config/constants/editableFloatingToolbarClassNames', '../../config/constants/editableTypes', '../../selectors/selectEditableValue', '../../store/index', '../Controls', '../floating-toolbar/FloatingToolbar', './EditableProcessorContext', './getEditableUniqueId', './isMapped'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = FragmentContentFloatingToolbar;

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _editableFloatingToolbarButtons = require("../../config/constants/editableFloatingToolbarButtons");

  var _editableFloatingToolbarClassNames = require("../../config/constants/editableFloatingToolbarClassNames");

  var _editableTypes = require("../../config/constants/editableTypes");

  var _selectEditableValue = _interopRequireDefault(require("../../selectors/selectEditableValue"));

  var _index = require("../../store/index");

  var _Controls = require("../Controls");

  var _FloatingToolbar = _interopRequireDefault(require("../floating-toolbar/FloatingToolbar"));

  var _EditableProcessorContext = require("./EditableProcessorContext");

  var _getEditableUniqueId = _interopRequireDefault(require("./getEditableUniqueId"));

  var _isMapped = _interopRequireDefault(require("./isMapped"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function FragmentContentFloatingToolbar(_ref) {
    var editables = _ref.editables,
        fragmentEntryLinkId = _ref.fragmentEntryLinkId,
        onButtonClick = _ref.onButtonClick;
    var isActive = (0, _Controls.useIsActive)();
    var isProccessorEnabled = (0, _EditableProcessorContext.useIsProcessorEnabled)();
    var editable = (0, _react.useMemo)(function () {
      var activeEditable = {
        editableId: null,
        editableValueNamespace: null,
        element: null,
        processor: null
      };

      if (editables) {
        activeEditable = editables.find(function (editable) {
          return isActive((0, _getEditableUniqueId["default"])(fragmentEntryLinkId, editable.editableId));
        }) || activeEditable;
      }

      return activeEditable;
    }, [editables, fragmentEntryLinkId, isActive]);
    var state = (0, _index.useSelector)(function (state) {
      return state;
    });
    var editableValue = (0, _selectEditableValue["default"])(state, fragmentEntryLinkId, editable.editableId, editable.editableValueNamespace);
    var editableHasActiveProcessor = !isProccessorEnabled((0, _getEditableUniqueId["default"])(fragmentEntryLinkId, editable.editableId));
    var floatingToolbarButtons = (0, _react.useMemo)(function () {
      if (!editable.editableId) {
        return [];
      }

      var _editableValue$config = editableValue.config,
          config = _editableValue$config === void 0 ? {} : _editableValue$config;
      var editableIsMapped = (0, _isMapped["default"])(editableValue);
      var showLinkButton = editable.type == _editableTypes.EDITABLE_TYPES.text || editable.type == _editableTypes.EDITABLE_TYPES.image || editable.type == _editableTypes.EDITABLE_TYPES.link;
      var buttons = [];

      if (showLinkButton) {
        _editableFloatingToolbarButtons.EDITABLE_FLOATING_TOOLBAR_BUTTONS.link.className = config.href || (0, _isMapped["default"])(config) ? _editableFloatingToolbarClassNames.EDITABLE_FLOATING_TOOLBAR_CLASSNAMES.linked : '';
        buttons.push(_editableFloatingToolbarButtons.EDITABLE_FLOATING_TOOLBAR_BUTTONS.link);
      }

      if ((editable.type === _editableTypes.EDITABLE_TYPES.image || editable.type === _editableTypes.EDITABLE_TYPES.backgroundImage) && !editableIsMapped) {
        buttons.push(_editableFloatingToolbarButtons.EDITABLE_FLOATING_TOOLBAR_BUTTONS.imageProperties);
      } else {
        _editableFloatingToolbarButtons.EDITABLE_FLOATING_TOOLBAR_BUTTONS.edit.className = editableIsMapped ? _editableFloatingToolbarClassNames.EDITABLE_FLOATING_TOOLBAR_CLASSNAMES.disabled : '';
        buttons.push(_editableFloatingToolbarButtons.EDITABLE_FLOATING_TOOLBAR_BUTTONS.edit);
      }

      _editableFloatingToolbarButtons.EDITABLE_FLOATING_TOOLBAR_BUTTONS.map.className = editableIsMapped ? _editableFloatingToolbarClassNames.EDITABLE_FLOATING_TOOLBAR_CLASSNAMES.mapped : '';
      buttons.push(_editableFloatingToolbarButtons.EDITABLE_FLOATING_TOOLBAR_BUTTONS.map);
      return buttons;
    }, [editable.editableId, editable.type, editableValue]);
    var handleButtonClick = (0, _react.useCallback)(function (buttonId) {
      return onButtonClick(buttonId, editable.editableId);
    }, [editable.editableId, onButtonClick]);
    return editable.editableId && editableHasActiveProcessor && _react["default"].createElement(_FloatingToolbar["default"], {
      buttons: floatingToolbarButtons,
      item: {
        editableId: editable.editableId,
        editableType: editable.type,
        fragmentEntryLinkId: fragmentEntryLinkId,
        itemId: (0, _getEditableUniqueId["default"])(fragmentEntryLinkId, editable.editableId)
      },
      itemElement: editable.element,
      onButtonClick: handleButtonClick
    });
  }
  //# sourceMappingURL=FragmentContentFloatingToolbar.js.map
});
//# sourceMappingURL=FragmentContentFloatingToolbar.js.map