Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/fragment-content/FragmentContent", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../actions/index', '../../config/constants/editableFloatingToolbarButtons', '../../selectors/selectCanUpdateLayoutContent', '../../selectors/selectSegmentsExperienceId', '../../store/index', '../CollectionItemContext', '../Frame', '../Layout', '../UnsafeHTML', './EditableProcessorContext', './FragmentContentFloatingToolbar', './FragmentContentInteractionsFilter', './FragmentContentProcessor', './getAllEditables', './getEditableUniqueId', './resolveEditableValue'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _index = require("../../actions/index");

  var _editableFloatingToolbarButtons = require("../../config/constants/editableFloatingToolbarButtons");

  var _selectCanUpdateLayoutContent = _interopRequireDefault(require("../../selectors/selectCanUpdateLayoutContent"));

  var _selectSegmentsExperienceId = _interopRequireDefault(require("../../selectors/selectSegmentsExperienceId"));

  var _index2 = require("../../store/index");

  var _CollectionItemContext = require("../CollectionItemContext");

  var _Frame = require("../Frame");

  var _Layout = _interopRequireDefault(require("../Layout"));

  var _UnsafeHTML = _interopRequireDefault(require("../UnsafeHTML"));

  var _EditableProcessorContext = require("./EditableProcessorContext");

  var _FragmentContentFloatingToolbar = _interopRequireDefault(require("./FragmentContentFloatingToolbar"));

  var _FragmentContentInteractionsFilter = _interopRequireDefault(require("./FragmentContentInteractionsFilter"));

  var _FragmentContentProcessor = _interopRequireDefault(require("./FragmentContentProcessor"));

  var _getAllEditables = _interopRequireDefault(require("./getAllEditables"));

  var _getEditableUniqueId = _interopRequireDefault(require("./getEditableUniqueId"));

  var _resolveEditableValue = _interopRequireDefault(require("./resolveEditableValue"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var FragmentContent = _react["default"].forwardRef(function (_ref, ref) {
    var fragmentEntryLinkId = _ref.fragmentEntryLinkId,
        itemId = _ref.itemId;
    var dispatch = (0, _index2.useDispatch)();
    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
    var editableProcessorUniqueId = (0, _EditableProcessorContext.useEditableProcessorUniqueId)();
    var frameContext = (0, _Frame.useFrameContext)();
    var setEditableProcessorUniqueId = (0, _EditableProcessorContext.useSetEditableProcessorUniqueId)();
    var canUpdateLayoutContent = (0, _index2.useSelector)(_selectCanUpdateLayoutContent["default"]);
    var getFieldValue = (0, _CollectionItemContext.useGetFieldValue)();
    var getContent = (0, _CollectionItemContext.useGetContent)();
    var renderFragmentContent = (0, _CollectionItemContext.useRenderFragmentContent)();

    var _useState = (0, _react.useState)([]),
        _useState2 = _slicedToArray(_useState, 2),
        editables = _useState2[0],
        setEditables = _useState2[1];

    var editableElements = (0, _react.useMemo)(function () {
      return editables.map(function (editable) {
        return editable.element;
      });
    }, [editables]);
    /**
     * Updates editables array for the rendered fragment.
     * @param {HTMLElement} [nextFragmentElement] Fragment element
     *  If not specified, fragmentElement state is used instead.
     * @return {Array} Updated editables array
     */

    var onRender = (0, _react.useCallback)(function (fragmentElement) {
      var updatedEditableValues = [];

      if (isMounted()) {
        updatedEditableValues = (0, _getAllEditables["default"])(fragmentElement);
      }

      setEditables(updatedEditableValues);
      return updatedEditableValues;
    }, [isMounted]);
    var fragmentEntryLinks = (0, _index2.useSelector)(function (state) {
      return state.fragmentEntryLinks;
    });
    var fragmentEntryLink = fragmentEntryLinks[fragmentEntryLinkId];
    var languageId = (0, _index2.useSelector)(function (state) {
      return state.languageId;
    });
    var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId["default"]);
    var defaultContent = getContent(fragmentEntryLink);

    var _useState3 = (0, _react.useState)(defaultContent),
        _useState4 = _slicedToArray(_useState3, 2),
        content = _useState4[0],
        setContent = _useState4[1];

    var editableValues = fragmentEntryLink ? fragmentEntryLink.editableValues : {};
    (0, _react.useEffect)(function () {
      renderFragmentContent({
        fragmentEntryLinkId: fragmentEntryLinkId,
        onNetworkStatus: dispatch,
        segmentsExperienceId: segmentsExperienceId
      }).then(function (action) {
        dispatch((0, _index.updateFragmentEntryLinkContent)(_objectSpread({}, action, {
          fragmentEntryLinkId: fragmentEntryLinkId
        })));
      });
    }, [dispatch, fragmentEntryLinkId, renderFragmentContent, segmentsExperienceId]);
    /**
     * fragmentElement keeps a copy of the fragment real HTML,
     * we perform editableValues replacements over this copy
     * to avoid multiple re-renders, when every replacement has
     * finished, this function must be called.
     *
     * Synchronizes fragmentElement's content to the real fragment
     * content. When this happens, the real re-render is performed.
     */

    (0, _react.useEffect)(function () {
      var fragmentElement = document.createElement('div');

      if (!editableProcessorUniqueId) {
        fragmentElement.innerHTML = defaultContent;
        Promise.all((0, _getAllEditables["default"])(fragmentElement).map(function (editable) {
          return (0, _resolveEditableValue["default"])(editableValues, editable.editableId, editable.editableValueNamespace, languageId, getFieldValue).then(function (_ref2) {
            var _ref3 = _slicedToArray(_ref2, 2),
                value = _ref3[0],
                editableConfig = _ref3[1];

            editable.processor.render(editable.element, value, editableConfig);
            editable.element.classList.add('page-editor__editable');
          });
        })).then(function () {
          if (isMounted() && fragmentElement) {
            setContent(fragmentElement.innerHTML);
          }
        });
      }

      return function () {
        fragmentElement = null;
      };
    }, [defaultContent, editableProcessorUniqueId, editableValues, getFieldValue, isMounted, languageId]);
    var getPortals = (0, _react.useCallback)(function (element) {
      return Array.from(element.querySelectorAll('lfr-drop-zone')).map(function (dropZoneElement) {
        var mainItemId = dropZoneElement.getAttribute('uuid') || '';

        var Component = function Component() {
          return mainItemId ? _react["default"].createElement(_Layout["default"], {
            mainItemId: mainItemId
          }) : null;
        };

        Component.displayName = "DropZone(".concat(mainItemId, ")");
        return {
          Component: Component,
          element: dropZoneElement
        };
      });
    }, []);
    var onFloatingToolbarButtonClick = (0, _react.useCallback)(function (buttonId, editableId) {
      if (buttonId === _editableFloatingToolbarButtons.EDITABLE_FLOATING_TOOLBAR_BUTTONS.edit.id) {
        setEditableProcessorUniqueId((0, _getEditableUniqueId["default"])(fragmentEntryLinkId, editableId));
      }
    }, [fragmentEntryLinkId, setEditableProcessorUniqueId]);
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_FragmentContentInteractionsFilter["default"], {
      editableElements: editableElements,
      fragmentEntryLinkId: fragmentEntryLinkId,
      itemId: itemId
    }, _react["default"].createElement(_UnsafeHTML["default"], {
      className: (0, _classnames["default"])('page-editor__fragment-content', {
        'page-editor__fragment-content--portlet-topper-hidden': !canUpdateLayoutContent
      }),
      contentRef: ref,
      getPortals: getPortals,
      globalContext: frameContext || window,
      markup: content,
      onRender: onRender
    })), canUpdateLayoutContent && _react["default"].createElement(_FragmentContentFloatingToolbar["default"], {
      editables: editables,
      fragmentEntryLinkId: fragmentEntryLinkId,
      onButtonClick: onFloatingToolbarButtonClick
    }), _react["default"].createElement(_FragmentContentProcessor["default"], {
      editables: editables,
      fragmentEntryLinkId: fragmentEntryLinkId
    }));
  });

  FragmentContent.displayName = 'FragmentContent';
  var _default = FragmentContent;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentContent.js.map
});
//# sourceMappingURL=FragmentContent.js.map