Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/floating-toolbar/RowConfigurationPanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../prop-types/index', '../../config/constants/layoutDataItemDefaultConfigurations', '../../config/constants/layoutDataItemTypes', '../../config/constants/viewportSizes', '../../config/index', '../../selectors/selectSegmentsExperienceId', '../../store/index', '../../thunks/updateItemConfig', '../../thunks/updateRowColumns', '../../utils/getResponsiveConfig', '../../utils/useId', './RowConfigurationCheckboxField', './RowConfigurationSelectField'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.RowConfigurationPanel = void 0;

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _index = require("../../../prop-types/index");

  var _layoutDataItemDefaultConfigurations = require("../../config/constants/layoutDataItemDefaultConfigurations");

  var _layoutDataItemTypes = require("../../config/constants/layoutDataItemTypes");

  var _viewportSizes = require("../../config/constants/viewportSizes");

  var _index2 = require("../../config/index");

  var _selectSegmentsExperienceId = _interopRequireDefault(require("../../selectors/selectSegmentsExperienceId"));

  var _index3 = require("../../store/index");

  var _updateItemConfig = _interopRequireDefault(require("../../thunks/updateItemConfig"));

  var _updateRowColumns = _interopRequireDefault(require("../../thunks/updateRowColumns"));

  var _getResponsiveConfig = require("../../utils/getResponsiveConfig");

  var _useId = require("../../utils/useId");

  var _RowConfigurationCheckboxField = require("./RowConfigurationCheckboxField");

  var _RowConfigurationSelectField = require("./RowConfigurationSelectField");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var MODULES_PER_ROW_OPTIONS = [[1], [1, 2], [1, 3], [2, 4], [2, 5], [2, 3, 6]];
  var NUMBER_OF_COLUMNS_OPTIONS = ['1', '2', '3', '4', '5', '6'];
  var VERTICAL_ALIGNMENT_OPTIONS = [{
    label: Liferay.Language.get('top'),
    value: 'top'
  }, {
    label: Liferay.Language.get('middle'),
    value: 'middle'
  }, {
    label: Liferay.Language.get('bottom'),
    value: 'bottom'
  }];
  var ROW_CONFIGURATION_IDENTIFIERS = {
    gutters: 'gutters',
    modulesPerRow: 'modulesPerRow',
    numberOfColumns: 'numberOfColumns',
    reverseOrder: 'reverseOrder',
    verticalAlignment: 'verticalAlignment'
  };

  var RowConfigurationPanel = function RowConfigurationPanel(_ref) {
    var item = _ref.item;
    var availableViewportSizes = _index2.config.availableViewportSizes;
    var dispatch = (0, _index3.useDispatch)();
    var rowModulesPerRowId = (0, _useId.useId)();
    var rowNumberOfColumnsId = (0, _useId.useId)();
    var rowVerticalAlignmentId = (0, _useId.useId)();
    var segmentsExperienceId = (0, _index3.useSelector)(_selectSegmentsExperienceId["default"]);
    var selectedViewportSize = (0, _index3.useSelector)(function (state) {
      return state.selectedViewportSize;
    });

    var handleConfigurationValueChanged = function handleConfigurationValueChanged(identifier, value) {
      var itemConfig = _defineProperty({}, identifier, value);

      if (selectedViewportSize !== _viewportSizes.VIEWPORT_SIZES.desktop && identifier !== ROW_CONFIGURATION_IDENTIFIERS.gutters) {
        itemConfig = _defineProperty({}, selectedViewportSize, itemConfig);
      }

      if (identifier === ROW_CONFIGURATION_IDENTIFIERS.numberOfColumns) {
        var currentNumberOfColumns = rowConfig.numberOfColumns;
        var newNumberOfColumns = value;
        var columnsToBeModified = Math.abs(newNumberOfColumns - currentNumberOfColumns);

        if (columnsToBeModified === 0) {
          return;
        }

        if (item && item.itemId) {
          dispatch((0, _updateRowColumns["default"])({
            itemId: item.itemId,
            numberOfColumns: newNumberOfColumns,
            segmentsExperienceId: segmentsExperienceId,
            viewportSizeId: selectedViewportSize
          }));
        }

        return;
      }

      dispatch((0, _updateItemConfig["default"])({
        itemConfig: itemConfig,
        itemId: item.itemId,
        segmentsExperienceId: segmentsExperienceId
      }));
    };

    var getModulesPerRowOptionLabel = function getModulesPerRowOptionLabel(value) {
      return value > 1 ? Liferay.Language.get('x-modules-per-row') : Liferay.Language.get('x-module-per-row');
    };

    var rowConfig = (0, _getResponsiveConfig.getResponsiveConfig)(_objectSpread({}, _layoutDataItemDefaultConfigurations.LAYOUT_DATA_ITEM_DEFAULT_CONFIGURATIONS[_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row], {}, item.config), selectedViewportSize);
    var gutters = rowConfig.gutters,
        modulesPerRow = rowConfig.modulesPerRow,
        numberOfColumns = rowConfig.numberOfColumns,
        reverseOrder = rowConfig.reverseOrder,
        verticalAlignment = rowConfig.verticalAlignment;
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_RowConfigurationSelectField.RowConfigurationSelectField, {
      fieldValue: numberOfColumns,
      id: rowNumberOfColumnsId,
      identifier: ROW_CONFIGURATION_IDENTIFIERS.numberOfColumns,
      label: Liferay.Language.get('number-of-columns'),
      onValueChange: handleConfigurationValueChanged,
      options: NUMBER_OF_COLUMNS_OPTIONS.map(function (option) {
        return {
          label: option
        };
      })
    }), numberOfColumns > 1 && _react["default"].createElement(_RowConfigurationCheckboxField.RowConfigurationCheckboxField, {
      fieldValue: gutters,
      identifier: ROW_CONFIGURATION_IDENTIFIERS.gutters,
      label: Liferay.Language.get('show-gutter'),
      onValueChange: handleConfigurationValueChanged
    }), _index2.config.responsiveEnabled && _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("div", {
      className: "align-items-center d-flex justify-content-between page-editor__floating-toolbar__label pt-3"
    }, _react["default"].createElement("p", {
      className: "mb-3 text-uppercase"
    }, Liferay.Language.get('styles')), _react["default"].createElement("p", null, Liferay.Language.get(availableViewportSizes[selectedViewportSize].label), _react["default"].createElement(_icon["default"], {
      className: "ml-1",
      symbol: availableViewportSizes[selectedViewportSize].icon
    }))), _react["default"].createElement(_RowConfigurationSelectField.RowConfigurationSelectField, {
      fieldValue: modulesPerRow,
      getOptionLabel: getModulesPerRowOptionLabel,
      id: rowModulesPerRowId,
      identifier: ROW_CONFIGURATION_IDENTIFIERS.modulesPerRow,
      label: Liferay.Language.get('layout'),
      onValueChange: handleConfigurationValueChanged,
      options: MODULES_PER_ROW_OPTIONS[rowConfig.numberOfColumns - 1].map(function (option) {
        return {
          label: Liferay.Util.sub(getModulesPerRowOptionLabel(option), option),
          value: option
        };
      })
    }), numberOfColumns === 2 && modulesPerRow === 1 && _react["default"].createElement(_RowConfigurationCheckboxField.RowConfigurationCheckboxField, {
      fieldValue: reverseOrder,
      identifier: ROW_CONFIGURATION_IDENTIFIERS.reverseOrder,
      label: Liferay.Language.get('inverse-order'),
      onValueChange: handleConfigurationValueChanged
    }), _react["default"].createElement(_RowConfigurationSelectField.RowConfigurationSelectField, {
      fieldValue: verticalAlignment,
      id: rowVerticalAlignmentId,
      identifier: ROW_CONFIGURATION_IDENTIFIERS.verticalAlignment,
      label: Liferay.Language.get('vertical-alignment'),
      onValueChange: handleConfigurationValueChanged,
      options: VERTICAL_ALIGNMENT_OPTIONS
    })));
  };

  exports.RowConfigurationPanel = RowConfigurationPanel;
  //# sourceMappingURL=RowConfigurationPanel.js.map
});
//# sourceMappingURL=RowConfigurationPanel.js.map