Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/floating-toolbar/MappingSelector", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../common/components/ItemSelector', '../../actions/index', '../../config/constants/compatibleTypes', '../../config/constants/pageTypes', '../../config/index', '../../services/InfoItemService', '../../store/index', '../../utils/useId', '../CollectionItemContext'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = _default;

  var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _ItemSelector = _interopRequireDefault(require("../../../common/components/ItemSelector"));

  var _index = require("../../actions/index");

  var _compatibleTypes = require("../../config/constants/compatibleTypes");

  var _pageTypes = require("../../config/constants/pageTypes");

  var _index2 = require("../../config/index");

  var _InfoItemService = _interopRequireDefault(require("../../services/InfoItemService"));

  var _index3 = require("../../store/index");

  var _useId = require("../../utils/useId");

  var _CollectionItemContext = require("../CollectionItemContext");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  var MAPPING_SOURCE_TYPE_IDS = {
    content: 'content',
    structure: 'structure'
  };
  var UNMAPPED_OPTION = {
    label: "-- ".concat(Liferay.Language.get('unmapped'), " --"),
    value: 'unmapped'
  };

  function loadFields(_ref) {
    var dispatch = _ref.dispatch,
        fieldType = _ref.fieldType,
        selectedItem = _ref.selectedItem,
        selectedMappingTypes = _ref.selectedMappingTypes,
        selectedSourceTypeId = _ref.selectedSourceTypeId;
    var promise;

    if (selectedSourceTypeId === MAPPING_SOURCE_TYPE_IDS.structure) {
      promise = _InfoItemService["default"].getAvailableStructureMappingFields({
        classNameId: selectedMappingTypes.type.id,
        classTypeId: selectedMappingTypes.subtype.id,
        onNetworkStatus: dispatch
      });
    } else if (selectedSourceTypeId === MAPPING_SOURCE_TYPE_IDS.content && selectedItem.classNameId && selectedItem.classPK) {
      promise = _InfoItemService["default"].getAvailableAssetMappingFields({
        classNameId: selectedItem.classNameId,
        classPK: selectedItem.classPK,
        onNetworkStatus: dispatch
      });
    }

    if (promise) {
      return promise.then(function (response) {
        if (Array.isArray(response)) {
          return response.filter(function (field) {
            return _compatibleTypes.COMPATIBLE_TYPES[fieldType].indexOf(field.type) !== -1;
          });
        }

        return [];
      });
    }

    return Promise.resolve([]);
  }

  function _default(_ref2) {
    var fieldType = _ref2.fieldType,
        mappedItem = _ref2.mappedItem,
        onMappingSelect = _ref2.onMappingSelect;
    var collectionFields = (0, _CollectionItemContext.useCollectionFields)();
    return collectionFields ? _react["default"].createElement(CollectionMappingSelector, {
      collectionFields: collectionFields,
      fieldType: fieldType,
      mappedItem: mappedItem,
      onMappingSelect: onMappingSelect
    }) : _react["default"].createElement(MappingSelector, {
      fieldType: fieldType,
      mappedItem: mappedItem,
      onMappingSelect: onMappingSelect
    });
  }

  function CollectionMappingSelector(_ref3) {
    var collectionFields = _ref3.collectionFields,
        fieldType = _ref3.fieldType,
        mappedItem = _ref3.mappedItem,
        onMappingSelect = _ref3.onMappingSelect;
    var mappingSelectorFieldSelectId = (0, _useId.useId)();
    var fields = collectionFields.filter(function (field) {
      return _compatibleTypes.COMPATIBLE_TYPES[fieldType].indexOf(field.type) !== -1;
    });
    return _react["default"].createElement(_form["default"].Group, {
      small: true
    }, _react["default"].createElement("label", {
      htmlFor: mappingSelectorFieldSelectId
    }, Liferay.Language.get('field')), _react["default"].createElement(_form.ClaySelectWithOption, {
      "aria-label": Liferay.Language.get('field'),
      id: mappingSelectorFieldSelectId,
      onChange: function onChange(event) {
        if (event.target.value === UNMAPPED_OPTION.value) {
          onMappingSelect({
            collectionFieldId: ''
          });
        } else {
          onMappingSelect({
            collectionFieldId: event.target.value
          });
        }
      },
      options: fields && fields.length ? [UNMAPPED_OPTION].concat(_toConsumableArray(fields.map(function (_ref4) {
        var key = _ref4.key,
            label = _ref4.label;
        return {
          label: label,
          value: key
        };
      }))) : [UNMAPPED_OPTION],
      value: mappedItem.collectionFieldId
    }));
  }

  function MappingSelector(_ref5) {
    var fieldType = _ref5.fieldType,
        mappedItem = _ref5.mappedItem,
        onMappingSelect = _ref5.onMappingSelect;
    var dispatch = (0, _index3.useDispatch)();
    var mappedInfoItems = (0, _index3.useSelector)(function (state) {
      return state.mappedInfoItems;
    });
    var mappingSelectorSourceSelectId = (0, _useId.useId)();
    var mappingSelectorFieldSelectId = (0, _useId.useId)();
    var selectedMappingTypes = _index2.config.selectedMappingTypes;

    var _useState = (0, _react.useState)([]),
        _useState2 = _slicedToArray(_useState, 2),
        fields = _useState2[0],
        setFields = _useState2[1];

    var _useState3 = (0, _react.useState)(mappedItem),
        _useState4 = _slicedToArray(_useState3, 2),
        selectedItem = _useState4[0],
        setSelectedItem = _useState4[1];

    var _useState5 = (0, _react.useState)(mappedItem.mappedField || _index2.config.pageType === _pageTypes.PAGE_TYPES.display ? MAPPING_SOURCE_TYPE_IDS.structure : MAPPING_SOURCE_TYPE_IDS.content),
        _useState6 = _slicedToArray(_useState5, 2),
        selectedSourceTypeId = _useState6[0],
        setSelectedSourceTypeId = _useState6[1];

    (0, _react.useEffect)(function () {
      var infoItem = mappedInfoItems.find(function (infoItem) {
        return infoItem.classNameId === mappedItem.classNameId && infoItem.classPK === mappedItem.classPK;
      });
      setSelectedItem(function (selectedItem) {
        return _objectSpread({}, infoItem, {}, mappedItem, {}, selectedItem);
      });
    }, [mappedItem, mappedInfoItems]);
    (0, _react.useEffect)(function () {
      var data = selectedSourceTypeId === MAPPING_SOURCE_TYPE_IDS.structure ? {
        dispatch: dispatch,
        fieldType: fieldType,
        selectedMappingTypes: selectedMappingTypes,
        selectedSourceTypeId: selectedSourceTypeId
      } : {
        dispatch: dispatch,
        fieldType: fieldType,
        selectedItem: selectedItem,
        selectedSourceTypeId: selectedSourceTypeId
      };
      loadFields(data).then(function (newFields) {
        setFields(newFields);
      });
    }, [dispatch, fieldType, selectedItem, selectedMappingTypes, selectedSourceTypeId]);
    return _react["default"].createElement(_react["default"].Fragment, null, _index2.config.pageType === _pageTypes.PAGE_TYPES.display && _react["default"].createElement(_form["default"].Group, {
      small: true
    }, _react["default"].createElement("label", {
      htmlFor: "mappingSelectorSourceSelect"
    }, Liferay.Language.get('source')), _react["default"].createElement(_form.ClaySelectWithOption, {
      "aria-label": Liferay.Language.get('source'),
      id: mappingSelectorSourceSelectId,
      onChange: function onChange(event) {
        setSelectedSourceTypeId(event.target.value);
        setSelectedItem({});
        onMappingSelect({
          classNameId: '',
          classPK: '',
          fieldId: '',
          mappedField: ''
        });
      },
      options: [{
        label: Liferay.Util.sub(Liferay.Language.get('x-default'), selectedMappingTypes.subtype ? selectedMappingTypes.subtype.label : selectedMappingTypes.type.label),
        value: MAPPING_SOURCE_TYPE_IDS.structure
      }, {
        label: Liferay.Language.get('specific-content'),
        value: MAPPING_SOURCE_TYPE_IDS.content
      }],
      value: selectedSourceTypeId
    })), selectedSourceTypeId === MAPPING_SOURCE_TYPE_IDS.content && _react["default"].createElement(_form["default"].Group, {
      small: true
    }, _react["default"].createElement(_ItemSelector["default"], {
      label: Liferay.Language.get('content'),
      onItemSelect: function onInfoItemSelect(selectedInfoItem) {
        setSelectedItem(selectedInfoItem);
        onMappingSelect({
          classNameId: '',
          classPK: '',
          fieldId: '',
          mappedField: ''
        });
      },
      selectedItemTitle: selectedItem.title
    })), _react["default"].createElement(_form["default"].Group, {
      small: true
    }, _react["default"].createElement("label", {
      htmlFor: "mappingSelectorFieldSelect"
    }, Liferay.Language.get('field')), _react["default"].createElement(_form.ClaySelectWithOption, {
      "aria-label": Liferay.Language.get('field'),
      disabled: !(fields && fields.length),
      id: mappingSelectorFieldSelectId,
      onChange: function onFieldSelect(event) {
        var fieldValue = event.target.value;
        var data = fieldValue === UNMAPPED_OPTION.value ? {
          classNameId: '',
          classPK: '',
          fieldId: '',
          mappedField: ''
        } : selectedSourceTypeId === MAPPING_SOURCE_TYPE_IDS.content ? {
          classNameId: selectedItem.classNameId,
          classPK: selectedItem.classPK,
          fieldId: fieldValue
        } : {
          mappedField: fieldValue
        };

        if (selectedSourceTypeId === MAPPING_SOURCE_TYPE_IDS.content) {
          var mappedInfoItem = mappedInfoItems.find(function (item) {
            return item.classNameId === selectedItem.classNameId && item.classPK === selectedItem.classPK;
          });

          if (!mappedInfoItem) {
            dispatch((0, _index.addMappedInfoItem)(_objectSpread({
              title: selectedItem.title
            }, data)));
          }

          setSelectedItem(function (selectedItem) {
            return _objectSpread({}, selectedItem, {
              fieldId: fieldValue
            });
          });
        } else {
          setSelectedItem(function (selectedItem) {
            return _objectSpread({}, selectedItem, {
              mappedField: fieldValue
            });
          });
        }

        onMappingSelect(data);
      },
      options: fields && fields.length ? [UNMAPPED_OPTION].concat(_toConsumableArray(fields.map(function (_ref6) {
        var key = _ref6.key,
            label = _ref6.label;
        return {
          label: label,
          value: key
        };
      }))) : [UNMAPPED_OPTION],
      value: selectedItem.mappedField || selectedItem.fieldId
    })));
  }
  //# sourceMappingURL=MappingSelector.js.map
});
//# sourceMappingURL=MappingSelector.js.map