Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/floating-toolbar/MappingPanel", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../prop-types/index', '../../config/constants/backgroundImageFragmentEntryProcessor', '../../config/constants/editableFragmentEntryProcessor', '../../config/constants/editableTypes', '../../selectors/selectEditableValue', '../../store/index', '../../thunks/updateEditableValues', '../fragment-content/isMapped', './MappingSelector'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.MappingPanel = MappingPanel;

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _index = require("../../../prop-types/index");

  var _backgroundImageFragmentEntryProcessor = require("../../config/constants/backgroundImageFragmentEntryProcessor");

  var _editableFragmentEntryProcessor = require("../../config/constants/editableFragmentEntryProcessor");

  var _editableTypes = require("../../config/constants/editableTypes");

  var _selectEditableValue = _interopRequireDefault(require("../../selectors/selectEditableValue"));

  var _index2 = require("../../store/index");

  var _updateEditableValues = _interopRequireDefault(require("../../thunks/updateEditableValues"));

  var _isMapped = _interopRequireDefault(require("../fragment-content/isMapped"));

  var _MappingSelector = _interopRequireDefault(require("./MappingSelector"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function MappingPanel(_ref) {
    var item = _ref.item;
    var editableId = item.editableId,
        editableType = item.editableType,
        fragmentEntryLinkId = item.fragmentEntryLinkId;
    var dispatch = (0, _index2.useDispatch)();
    var state = (0, _index2.useSelector)(function (state) {
      return state;
    });
    var fragmentEntryLink = state.fragmentEntryLinks[fragmentEntryLinkId];
    var processoryKey = editableType === _editableTypes.EDITABLE_TYPES.backgroundImage ? _backgroundImageFragmentEntryProcessor.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR : _editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR;
    var editableValue = (0, _selectEditableValue["default"])(state, fragmentEntryLinkId, editableId, processoryKey);

    return _react["default"].createElement(_MappingSelector["default"], {
      fieldType: editableType,
      mappedItem: editableValue,
      onMappingSelect: function updateEditableValue(newEditableValue) {
        var nextEditableValues = _objectSpread({}, fragmentEntryLink.editableValues, _defineProperty({}, processoryKey, _objectSpread({}, fragmentEntryLink.editableValues[processoryKey], _defineProperty({}, editableId, _objectSpread({
          config: (0, _isMapped["default"])(newEditableValue) ? _objectSpread({}, editableValue.config, {
            alt: ''
          }) : editableValue.config,
          defaultValue: editableValue.defaultValue
        }, newEditableValue)))));

        dispatch((0, _updateEditableValues["default"])({
          editableValues: nextEditableValues,
          fragmentEntryLinkId: fragmentEntryLinkId,
          segmentsExperienceId: state.segmentsExperienceId
        }));
      }
    });
  }
  //# sourceMappingURL=MappingPanel.js.map
});
//# sourceMappingURL=MappingPanel.js.map