Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/floating-toolbar/LinkPanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../prop-types/index', '../../config/constants/editableFragmentEntryProcessor', '../../config/constants/editableTypes', '../../selectors/selectSegmentsExperienceId', '../../store/index', '../../thunks/updateEditableValues', '../../utils/useId', '../CollectionItemContext', '../fragment-content/isMapped', './MappingSelector'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = LinkPanel;

  var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _index = require("../../../prop-types/index");

  var _editableFragmentEntryProcessor = require("../../config/constants/editableFragmentEntryProcessor");

  var _editableTypes = require("../../config/constants/editableTypes");

  var _selectSegmentsExperienceId = _interopRequireDefault(require("../../selectors/selectSegmentsExperienceId"));

  var _index2 = require("../../store/index");

  var _updateEditableValues = _interopRequireDefault(require("../../thunks/updateEditableValues"));

  var _useId = require("../../utils/useId");

  var _CollectionItemContext = require("../CollectionItemContext");

  var _isMapped = _interopRequireDefault(require("../fragment-content/isMapped"));

  var _MappingSelector = _interopRequireDefault(require("./MappingSelector"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var SOURCE_TYPES = {
    fromContentField: 'fromContentField',
    manual: 'manual'
  };
  var SOURCE_TYPES_OPTIONS = [{
    label: "".concat(Liferay.Language.get('manual')),
    value: SOURCE_TYPES.manual
  }, {
    label: "".concat(Liferay.Language.get('from-content-field')),
    value: SOURCE_TYPES.fromContentField
  }];
  var TARGET_OPTIONS = [{
    label: "".concat(Liferay.Language.get('self')),
    value: '_self'
  }, {
    label: "".concat(Liferay.Language.get('blank')),
    value: '_blank'
  }, {
    label: "".concat(Liferay.Language.get('parent')),
    value: '_parent'
  }, {
    label: "".concat(Liferay.Language.get('top')),
    value: '_top'
  }];

  function LinkPanel(_ref) {
    var item = _ref.item;
    var dispatch = (0, _index2.useDispatch)();
    var editableId = item.editableId,
        editableType = item.editableType,
        fragmentEntryLinkId = item.fragmentEntryLinkId;
    var floatingToolbarLinkHrefOptionId = (0, _useId.useId)();
    var floatingToolbarLinkSourceOptionId = (0, _useId.useId)();
    var floatingToolbarLinkTargetOptionId = (0, _useId.useId)();
    var fragmentEntryLinks = (0, _index2.useSelector)(function (state) {
      return state.fragmentEntryLinks;
    });
    var languageId = (0, _index2.useSelector)(function (state) {
      return state.languageId;
    });
    var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId["default"]);
    var editableValue = fragmentEntryLinks[fragmentEntryLinkId].editableValues[_editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editableId];
    var editableConfig = editableValue ? editableValue.config : {};

    var _useState = (0, _react.useState)((0, _isMapped["default"])(editableConfig) ? SOURCE_TYPES.fromContentField : SOURCE_TYPES.manual),
        _useState2 = _slicedToArray(_useState, 2),
        sourceType = _useState2[0],
        setSourceType = _useState2[1];

    var _useState3 = (0, _react.useState)(editableConfig.href || ''),
        _useState4 = _slicedToArray(_useState3, 2),
        href = _useState4[0],
        setHref = _useState4[1];

    var getFieldValue = (0, _CollectionItemContext.useGetFieldValue)();
    (0, _react.useEffect)(function () {
      var editableConfig = editableValue ? editableValue.config : {};
      setHref(function (href) {
        if (href !== editableConfig.href) {
          return editableConfig.href || '';
        }

        return href;
      });
    }, [editableValue]);
    (0, _react.useEffect)(function () {
      updateMappedHrefValue({
        classNameId: editableConfig.classNameId,
        classPK: editableConfig.classPK,
        fieldId: editableConfig.fieldId,
        languageId: languageId
      });
    }, [editableConfig.classNameId, editableConfig.classPK, editableConfig.fieldId, languageId, updateMappedHrefValue]);
    var updateRowConfig = (0, _react.useCallback)(function (newConfig) {
      var editableValues = fragmentEntryLinks[fragmentEntryLinkId].editableValues;
      var editableProcessorValues = editableValues[_editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR];

      var config = _objectSpread({}, newConfig);

      if (Object.keys(config).length > 0 && editableType !== _editableTypes.EDITABLE_TYPES.link) {
        config.mapperType = 'link';
      }

      var nextEditableValues = _objectSpread({}, editableValues, _defineProperty({}, _editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR, _objectSpread({}, editableProcessorValues, _defineProperty({}, editableId, _objectSpread({}, editableProcessorValues[editableId], {
        config: config
      })))));

      dispatch((0, _updateEditableValues["default"])({
        editableValues: nextEditableValues,
        fragmentEntryLinkId: fragmentEntryLinkId,
        segmentsExperienceId: segmentsExperienceId
      }));
    }, [dispatch, editableId, editableType, fragmentEntryLinkId, fragmentEntryLinks, segmentsExperienceId]);
    var updateMappedHrefValue = (0, _react.useCallback)(function (_ref2) {
      var classNameId = _ref2.classNameId,
          classPK = _ref2.classPK,
          fieldId = _ref2.fieldId,
          languageId = _ref2.languageId;

      if (!classNameId || !classPK || !fieldId) {
        return;
      }

      getFieldValue({
        classNameId: classNameId,
        classPK: classPK,
        fieldId: fieldId,
        languageId: languageId,
        onNetworkStatus: function onNetworkStatus() {}
      }).then(function (fieldValue) {
        setHref(fieldValue);
      });
    }, [getFieldValue]);
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_form["default"].Group, {
      small: true
    }, _react["default"].createElement("label", {
      htmlFor: floatingToolbarLinkSourceOptionId
    }, Liferay.Language.get('link')), _react["default"].createElement(_form.ClaySelectWithOption, {
      id: floatingToolbarLinkSourceOptionId,
      onChange: function onChange(event) {
        updateRowConfig({});
        setHref('');
        setSourceType(event.target.value);
      },
      options: SOURCE_TYPES_OPTIONS,
      type: "text",
      value: sourceType
    })), sourceType === SOURCE_TYPES.fromContentField && _react["default"].createElement(_MappingSelector["default"], {
      fieldType: _editableTypes.EDITABLE_TYPES.text,
      mappedItem: editableConfig,
      onMappingSelect: function onMappingSelect(mappedItem) {
        updateRowConfig(_objectSpread({}, mappedItem, {
          target: editableConfig.target
        }));
        updateMappedHrefValue({
          classNameId: mappedItem.classNameId,
          classPK: mappedItem.classPK,
          fieldId: mappedItem.fieldId,
          languageId: languageId
        });
      }
    }), (sourceType === SOURCE_TYPES.manual || href) && _react["default"].createElement(_form["default"].Group, null, _react["default"].createElement("label", {
      htmlFor: floatingToolbarLinkHrefOptionId
    }, Liferay.Language.get('url')), _react["default"].createElement(_form.ClayInput, {
      id: floatingToolbarLinkHrefOptionId,
      onBlur: function onBlur() {
        var previousValue = editableConfig.href || '';

        if (previousValue !== href) {
          updateRowConfig({
            href: href
          });
        }
      },
      onChange: function onChange(event) {
        setHref(event.target.value);
      },
      readOnly: sourceType !== SOURCE_TYPES.manual,
      sizing: "sm",
      type: "text",
      value: href
    })), _react["default"].createElement(_form["default"].Group, {
      small: true
    }, _react["default"].createElement("label", {
      htmlFor: floatingToolbarLinkTargetOptionId
    }, Liferay.Language.get('target')), _react["default"].createElement(_form.ClaySelectWithOption, {
      id: floatingToolbarLinkTargetOptionId,
      onChange: function onChange(event) {
        updateRowConfig(_objectSpread({}, editableConfig, {
          target: event.target.value
        }));
      },
      options: TARGET_OPTIONS,
      type: "text",
      value: editableConfig.target
    })));
  }
  //# sourceMappingURL=LinkPanel.js.map
});
//# sourceMappingURL=LinkPanel.js.map