Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/floating-toolbar/FragmentConfigurationPanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../prop-types/index', '../../config/constants/fragmentConfigurationFieldTypes', '../../config/constants/freemarkerFragmentEntryProcessor', '../../selectors/selectSegmentsExperienceId', '../../store/index', '../../thunks/updateFragmentConfiguration'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.FragmentConfigurationPanel = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _index = require("../../../prop-types/index");

  var _fragmentConfigurationFieldTypes = require("../../config/constants/fragmentConfigurationFieldTypes");

  var _freemarkerFragmentEntryProcessor = require("../../config/constants/freemarkerFragmentEntryProcessor");

  var _selectSegmentsExperienceId = _interopRequireDefault(require("../../selectors/selectSegmentsExperienceId"));

  var _index2 = require("../../store/index");

  var _updateFragmentConfiguration = _interopRequireDefault(require("../../thunks/updateFragmentConfiguration"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var FieldSet = function FieldSet(_ref) {
    var configurationValues = _ref.configurationValues,
        fields = _ref.fields,
        label = _ref.label,
        onValueSelect = _ref.onValueSelect;
    return _react["default"].createElement(_react["default"].Fragment, null, label && _react["default"].createElement("p", {
      className: "mb-3 sheet-subtitle"
    }, label), fields.map(function (field, index) {
      var FieldComponent = field.type && _fragmentConfigurationFieldTypes.FRAGMENT_CONFIGURATION_FIELD_TYPES[field.type];
      var fieldValue = configurationValues[field.name];
      return _react["default"].createElement(FieldComponent, {
        field: field,
        key: index,
        onValueSelect: onValueSelect,
        value: fieldValue
      });
    }));
  };

  var FragmentConfigurationPanel = function FragmentConfigurationPanel(_ref2) {
    var item = _ref2.item;
    var dispatch = (0, _index2.useDispatch)();
    var fragmentEntryLink = (0, _index2.useSelector)(function (state) {
      return state.fragmentEntryLinks[item.config.fragmentEntryLinkId];
    });
    var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId["default"]);
    var configuration = fragmentEntryLink.configuration;
    var defaultConfigurationValues = fragmentEntryLink.defaultConfigurationValues;

    var onValueSelect = (0, _react.useCallback)(function (name, value) {
      var configurationValues = getConfigurationValues(defaultConfigurationValues, fragmentEntryLink);

      var nextConfigurationValues = _objectSpread({}, configurationValues, _defineProperty({}, name, value));

      dispatch((0, _updateFragmentConfiguration["default"])({
        configurationValues: nextConfigurationValues,
        fragmentEntryLink: fragmentEntryLink,
        segmentsExperienceId: segmentsExperienceId
      }));
    }, [defaultConfigurationValues, dispatch, fragmentEntryLink, segmentsExperienceId]);
    return _react["default"].createElement(_react["default"].Fragment, null, configuration.fieldSets.map(function (fieldSet, index) {
      return _react["default"].createElement(FieldSet, {
        configurationValues: getConfigurationValues(defaultConfigurationValues, fragmentEntryLink),
        fields: fieldSet.fields,
        key: index,
        label: fieldSet.label,
        onValueSelect: onValueSelect
      });
    }), _react["default"].createElement(RestoreButton, {
      onRestoreButtonClick: function onRestoreButtonClick() {
        dispatch((0, _updateFragmentConfiguration["default"])({
          configurationValues: defaultConfigurationValues,
          fragmentEntryLink: fragmentEntryLink,
          segmentsExperienceId: segmentsExperienceId
        }));
      }
    }));
  };

  exports.FragmentConfigurationPanel = FragmentConfigurationPanel;

  var RestoreButton = function RestoreButton(_ref3) {
    var onRestoreButtonClick = _ref3.onRestoreButtonClick;
    return _react["default"].createElement(_button["default"], {
      borderless: true,
      className: "w-100",
      displayType: "secondary",
      onClick: onRestoreButtonClick,
      small: true
    }, _react["default"].createElement(_icon["default"], {
      symbol: "restore"
    }), _react["default"].createElement("span", {
      className: "ml-2"
    }, Liferay.Language.get('restore-values')));
  };

  function getConfigurationValues(defaultConfigurationValues, fragmentEntryLink) {
    return _objectSpread({}, defaultConfigurationValues, {}, fragmentEntryLink.editableValues[_freemarkerFragmentEntryProcessor.FREEMARKER_FRAGMENT_ENTRY_PROCESSOR]);
  }
  //# sourceMappingURL=FragmentConfigurationPanel.js.map
});
//# sourceMappingURL=FragmentConfigurationPanel.js.map