Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/floating-toolbar/FloatingToolbar", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-metal-web$metal-position', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom', '../../../core/debounceRAF', '../../../prop-types/index', '../../config/constants/editableFloatingToolbarClassNames', '../../config/constants/floatingToolbarConfigurations', '../../config/index', '../../store/index', '../Controls'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = FloatingToolbar;

  var _button = require("@frontend-taglib-clay$clayui/button");

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _metalPosition = require("frontend-js-metal-web$metal-position");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDom = require("frontend-js-react-web$react-dom");

  var _debounceRAF = _interopRequireDefault(require("../../../core/debounceRAF"));

  var _index = require("../../../prop-types/index");

  var _editableFloatingToolbarClassNames = require("../../config/constants/editableFloatingToolbarClassNames");

  var _floatingToolbarConfigurations = require("../../config/constants/floatingToolbarConfigurations");

  var _index2 = require("../../config/index");

  var _index3 = require("../../store/index");

  var _Controls = require("../Controls");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function FloatingToolbar(_ref) {
    var buttons = _ref.buttons,
        item = _ref.item,
        itemElement = _ref.itemElement,
        _ref$onButtonClick = _ref.onButtonClick,
        onButtonClick = _ref$onButtonClick === void 0 ? function () {} : _ref$onButtonClick;
    var isActive = (0, _Controls.useIsActive)();
    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

    var _useState = (0, _react.useState)(null),
        _useState2 = _slicedToArray(_useState, 2),
        panelId = _useState2[0],
        setPanelId = _useState2[1];

    var panelRef = (0, _react.useRef)(null);
    var hoverItem = (0, _Controls.useHoverItem)();
    var toolbarRef = (0, _react.useRef)(null);

    var _useState3 = (0, _react.useState)(true),
        _useState4 = _slicedToArray(_useState3, 2),
        hidden = _useState4[0],
        setHidden = _useState4[1];

    var _useState5 = (0, _react.useState)(0),
        _useState6 = _slicedToArray(_useState5, 2),
        windowScrollPosition = _useState6[0],
        setWindowScrollPosition = _useState6[1];

    var _useState7 = (0, _react.useState)(0),
        _useState8 = _slicedToArray(_useState7, 2),
        windowWidth = _useState8[0],
        setWindowWidth = _useState8[1];

    var _useState9 = (0, _react.useState)(false),
        _useState10 = _slicedToArray(_useState9, 2),
        show = _useState10[0],
        setShow = _useState10[1];

    var languageId = (0, _index3.useSelector)(function (state) {
      return state.languageId;
    });
    var selectedViewportSize = (0, _index3.useSelector)(function (state) {
      return state.selectedViewportSize;
    });
    var PanelComponent = (0, _react.useMemo)(function () {
      return _floatingToolbarConfigurations.FLOATING_TOOLBAR_CONFIGURATIONS[panelId] || null;
    }, [panelId]);
    var alignElement = (0, _react.useCallback)(function (element, anchor, callback) {
      if (isMounted() && show && element && anchor && document.body.contains(anchor)) {
        try {
          _metalPosition.Align.align(element, anchor, getElementAlign(element, anchor, _index2.config.languageDirection[languageId] === 'rtl'), false);
        } catch (error) {
          console.error(error);
        }

        if (callback) {
          requestAnimationFrame(function () {
            if (isMounted() && show) {
              callback();
            }
          });
        }
      } else if (callback && isMounted() && show) {
        callback();
      }
    }, [isMounted, languageId, show]);
    var handleButtonClick = (0, _react.useCallback)(function (buttonId, newPanelId) {
      onButtonClick(buttonId);

      if (newPanelId) {
        if (newPanelId === panelId) {
          setPanelId(null);
        } else {
          setPanelId(newPanelId);
        }
      }
    }, [onButtonClick, panelId]);
    (0, _react.useEffect)(function () {
      setShow(isActive(item.itemId) && itemElement);
    }, [isActive, item.itemId, itemElement]);
    (0, _react.useEffect)(function () {
      var handleWindowResize = (0, _debounceRAF["default"])(function () {
        setWindowWidth(window.innerWidth);
      });
      var handleWindowScroll = (0, _debounceRAF["default"])(function () {
        setWindowScrollPosition(window.scrollY);
      });
      window.addEventListener('resize', handleWindowResize);
      window.addEventListener('scroll', handleWindowScroll);
      return function () {
        window.removeEventListener('resize', handleWindowResize);
        window.removeEventListener('scroll', handleWindowScroll);
      };
    }, []);
    (0, _react.useEffect)(function () {
      if (!itemElement) {
        return;
      }

      var _getComputedStyle = getComputedStyle(itemElement),
          itemRefMarginLeft = _getComputedStyle.marginLeft,
          itemRefMarginRight = _getComputedStyle.marginRight;

      var rtl = _index2.config.languageDirection[languageId] === 'rtl';
      var marginValue = rtl ? Math.abs(parseInt(itemRefMarginLeft, 10)) : parseInt(itemRefMarginRight, 10);

      if (show && marginValue) {
        toolbarRef.current.style.transform = "translate(".concat(marginValue, "px)");
      }
    }, [itemElement, languageId, show]);
    (0, _react.useEffect)(function () {
      alignElement(toolbarRef.current, itemElement, function () {
        alignElement(panelRef.current, toolbarRef.current, function () {
          setHidden(false);
        });
      });
    }, [alignElement, item.config, itemElement, panelId, selectedViewportSize, show, windowScrollPosition, windowWidth]);
    (0, _react.useEffect)(function () {
      var sidebarElement = document.querySelector('.page-editor__sidebar__content');

      if (sidebarElement) {
        var handleTransitionEnd = function handleTransitionEnd(event) {
          if (event.target === sidebarElement) {
            alignElement(toolbarRef.current, itemElement, function () {
              alignElement(panelRef.current, toolbarRef.current);
            });
            setHidden(false);
          }
        };

        var handleTransitionStart = function handleTransitionStart(event) {
          if (event.target === sidebarElement) {
            setHidden(true);
          }
        };

        sidebarElement.addEventListener('transitionend', handleTransitionEnd);
        sidebarElement.addEventListener('transitionstart', handleTransitionStart);
        return function () {
          sidebarElement.removeEventListener('transitionend', handleTransitionEnd);
          sidebarElement.removeEventListener('transitionstart', handleTransitionStart);
        };
      }
    }, [alignElement, item, itemElement]);
    (0, _react.useEffect)(function () {
      var sideNavigation = Liferay.SideNavigation && Liferay.SideNavigation.instance(document.querySelector('.product-menu-toggle'));

      var handleTransitionEnd = function handleTransitionEnd() {
        alignElement(toolbarRef.current, itemElement, function () {
          alignElement(panelRef.current, toolbarRef.current);
        });
        setHidden(false);
      };

      var handleTransitionStart = function handleTransitionStart() {
        setHidden(true);
      };

      var sideNavigationListeners = [];

      if (sideNavigation) {
        sideNavigationListeners = [sideNavigation.on('open.lexicon.sidenav', handleTransitionEnd), sideNavigation.on('openStart.lexicon.sidenav', handleTransitionStart), sideNavigation.on('closed.lexicon.sidenav', handleTransitionEnd), sideNavigation.on('closedStart.lexicon.sidenav', handleTransitionStart)];
      }

      return function () {
        sideNavigationListeners.forEach(function (listener) {
          return listener.removeListener();
        });
      };
    }, [alignElement, itemElement]);
    (0, _react.useEffect)(function () {
      if (panelId && !show) {
        setPanelId(null);
      }
    }, [panelId, show]);
    return show && buttons.length > 0 && _react["default"].createElement("div", {
      onClick: function onClick(event) {
        return event.stopPropagation();
      }
    }, (0, _reactDom.createPortal)(_react["default"].createElement("div", {
      className: (0, _classnames["default"])('p-2', 'page-editor__floating-toolbar', 'position-fixed', {
        'page-editor__floating-toolbar--hidden': hidden
      }),
      onMouseOver: function onMouseOver(event) {
        event.stopPropagation();
        hoverItem(null);
      },
      ref: toolbarRef
    }, _react["default"].createElement("div", {
      className: "popover position-static"
    }, _react["default"].createElement("div", {
      className: "d-flex p-2 popover-body"
    }, buttons.map(function (button) {
      return _react["default"].createElement(_button.ClayButtonWithIcon, {
        borderless: true,
        className: (0, _classnames["default"])('mx-1', button.className, {
          active: button.panelId === panelId,
          'lfr-portal-tooltip': button.title
        }),
        displayType: "secondary",
        key: button.id,
        onClick: function onClick() {
          return handleButtonClick(button.id, button.panelId);
        },
        small: true,
        symbol: button.icon,
        title: button.title
      });
    })))), document.body), PanelComponent && (0, _reactDom.createPortal)(_react["default"].createElement("div", {
      className: _editableFloatingToolbarClassNames.EDITABLE_FLOATING_TOOLBAR_CLASSNAMES.panel,
      ref: panelRef
    }, _react["default"].createElement("div", {
      className: (0, _classnames["default"])('p-3 popover popover-scrollable position-static', {
        'page-editor__floating-toolbar--hidden': hidden
      })
    }, _react["default"].createElement(PanelComponent, {
      item: item
    }))), document.body));
  }

  /**
   * @type {object}
   */
  var ELEMENT_AVAILABLE_POSITIONS = {
    bottom: [_metalPosition.Align.Bottom, _metalPosition.Align.BottomCenter, _metalPosition.Align.BottomLeft, _metalPosition.Align.BottomRight],
    left: [_metalPosition.Align.BottomLeft, _metalPosition.Align.Left, _metalPosition.Align.LeftCenter, _metalPosition.Align.TopRight],
    right: [_metalPosition.Align.BottomRight, _metalPosition.Align.Right, _metalPosition.Align.RightCenter, _metalPosition.Align.TopRight],
    top: [_metalPosition.Align.Top, _metalPosition.Align.TopCenter, _metalPosition.Align.TopLeft, _metalPosition.Align.TopRight]
  };
  /**
   * @type {object}
   */

  var ELEMENT_POSITION = {
    bottom: {
      left: _metalPosition.Align.BottomLeft,
      right: _metalPosition.Align.BottomRight
    },
    top: {
      left: _metalPosition.Align.TopLeft,
      right: _metalPosition.Align.TopRight
    }
  };
  /**
   * Gets a suggested align of an element to an anchor
   * @param {HTMLElement|null} element
   * @param {HTMLElement|null} anchor
   * @param {boolean} rtl
   * @private
   * @return {number} Selected align
   * @review
   */

  var getElementAlign = function getElementAlign(element, anchor, rtl) {
    var horizontal, vertical;

    try {
      horizontal = getHorizontalPosition(anchor, element, rtl);
      vertical = getVerticalPosition(anchor, element, horizontal);
    } catch (error) {}

    return ELEMENT_POSITION[vertical][horizontal];
  };
  /**
   * Gets an elements horizontal position. If the element fits at the preferred
   * position (left in rtl, right in ltr), it's placed there, otherwise it is
   * placed at the opposite.
   * @param {HTMLElement|null} element
   * @param {HTMLElement|null} anchor
   * @param {boolean} rtl
   * @private
   * @return {number} Selected horizontal position
   * @review
   */

  var getHorizontalPosition = function getHorizontalPosition(anchor, element, rtl) {
    var pageEditor = document.getElementById('page-editor');

    var _pageEditor$getBoundi = pageEditor.getBoundingClientRect(),
        pageEditorLeft = _pageEditor$getBoundi.left,
        pageEditorRight = _pageEditor$getBoundi.right;

    var _anchor$getBoundingCl = anchor.getBoundingClientRect(),
        anchorLeft = _anchor$getBoundingCl.left,
        anchorRight = _anchor$getBoundingCl.right;

    var _element$getBoundingC = element.getBoundingClientRect(),
        elementWidth = _element$getBoundingC.width;

    if (rtl) {
      return anchorLeft + elementWidth < pageEditorRight ? 'left' : 'right';
    } else {
      return anchorRight - elementWidth > pageEditorLeft ? 'right' : 'left';
    }
  };
  /**
   * Gets an elements vertical position. If the element fits at bottom,
   * it's placed there, otherwise it is placed at top.
   * @param {HTMLElement|null} element
   * @param {HTMLElement|null} anchor
   * @param {string} horizontalPosition
   * @private
   * @return {number} Selected vertical position
   * @review
   */

  var getVerticalPosition = function getVerticalPosition(anchor, element, horizontalPosition) {
    var alignFits = function alignFits(align, availableAlign) {
      try {
        return availableAlign.includes(_metalPosition.Align.suggestAlignBestRegion(element, anchor, align).position);
      } catch (error) {
        return true;
      }
    };

    var fallbackVertical = 'top';
    var vertical = 'bottom';

    if (!alignFits(ELEMENT_POSITION[vertical][horizontalPosition], ELEMENT_AVAILABLE_POSITIONS[vertical]) && alignFits(ELEMENT_POSITION[fallbackVertical][horizontalPosition], ELEMENT_AVAILABLE_POSITIONS[fallbackVertical])) {
      vertical = fallbackVertical;
    }

    return vertical;
  };
  //# sourceMappingURL=FloatingToolbar.js.map
});
//# sourceMappingURL=FloatingToolbar.js.map