Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/floating-toolbar/ContainerConfigurationPanel", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../prop-types/index', '../../config/constants/containerTypes', '../../config/constants/layoutDataItemDefaultConfigurations', '../../config/constants/layoutDataItemTypes', '../../selectors/selectSegmentsExperienceId', '../../store/index', '../../thunks/updateItemConfig', './ContainerBackgroundColorConfiguration', './ContainerBackgroundImageConfiguration', './ContainerPaddingConfiguration', './ContainerTypeConfiguration'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ContainerConfigurationPanel = void 0;

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _index = require("../../../prop-types/index");

  var _containerTypes = require("../../config/constants/containerTypes");

  var _layoutDataItemDefaultConfigurations = require("../../config/constants/layoutDataItemDefaultConfigurations");

  var _layoutDataItemTypes = require("../../config/constants/layoutDataItemTypes");

  var _selectSegmentsExperienceId = _interopRequireDefault(require("../../selectors/selectSegmentsExperienceId"));

  var _index2 = require("../../store/index");

  var _updateItemConfig = _interopRequireDefault(require("../../thunks/updateItemConfig"));

  var _ContainerBackgroundColorConfiguration = require("./ContainerBackgroundColorConfiguration");

  var _ContainerBackgroundImageConfiguration = require("./ContainerBackgroundImageConfiguration");

  var _ContainerPaddingConfiguration = require("./ContainerPaddingConfiguration");

  var _ContainerTypeConfiguration = require("./ContainerTypeConfiguration");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var ContainerConfigurationPanel = function ContainerConfigurationPanel(_ref) {
    var item = _ref.item;
    var dispatch = (0, _index2.useDispatch)();
    var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId["default"]);

    var containerConfig = _objectSpread({}, _layoutDataItemDefaultConfigurations.LAYOUT_DATA_ITEM_DEFAULT_CONFIGURATIONS[_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container], {}, item.config);

    var handleConfigurationValueChanged = function handleConfigurationValueChanged(itemConfig) {
      dispatch((0, _updateItemConfig["default"])({
        itemConfig: itemConfig,
        itemId: item.itemId,
        segmentsExperienceId: segmentsExperienceId
      }));
    };

    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("p", {
      className: "mb-3 sheet-subtitle"
    }, Liferay.Language.get('layout')), _react["default"].createElement(_ContainerTypeConfiguration.ContainerTypeConfiguration, {
      containerType: containerConfig.type,
      onValueChange: handleConfigurationValueChanged
    }), _react["default"].createElement(_ContainerPaddingConfiguration.ContainerPaddingVerticalConfiguration, {
      onValueChange: handleConfigurationValueChanged,
      paddingBottom: containerConfig.paddingBottom,
      paddingTop: containerConfig.paddingTop
    }), containerConfig.type === _containerTypes.CONTAINER_TYPES.fluid && _react["default"].createElement(_ContainerPaddingConfiguration.ContainerPaddingHorizontalConfiguration, {
      onValueChange: handleConfigurationValueChanged,
      paddingHorizontal: containerConfig.paddingHorizontal
    }), _react["default"].createElement("p", {
      className: "mb-3 sheet-subtitle"
    }, Liferay.Language.get('background-color')), _react["default"].createElement(_ContainerBackgroundColorConfiguration.ContainerBackgroundColorConfiguration, {
      backgroundColor: containerConfig.backgroundColorCssClass,
      onValueChange: handleConfigurationValueChanged
    }), _react["default"].createElement("p", {
      className: "mb-3 sheet-subtitle"
    }, Liferay.Language.get('background-image')), _react["default"].createElement(_ContainerBackgroundImageConfiguration.ContainerBackgroundImageConfiguration, {
      backgroundImage: containerConfig.backgroundImage,
      onValueChange: handleConfigurationValueChanged
    }));
  };

  exports.ContainerConfigurationPanel = ContainerConfigurationPanel;
  //# sourceMappingURL=ContainerConfigurationPanel.js.map
});
//# sourceMappingURL=ContainerConfigurationPanel.js.map