Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/floating-toolbar/CollectionConfigurationPanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$react', '../../../app/config/index', '../../../common/components/CollectionSelector', '../../config/constants/layoutDataItemDefaultConfigurations', '../../config/constants/layoutDataItemTypes', '../../selectors/selectSegmentsExperienceId', '../../services/InfoItemService', '../../store/index', '../../thunks/updateItemConfig', '../../utils/useId'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.CollectionConfigurationPanel = void 0;

  var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _index = require("../../../app/config/index");

  var _CollectionSelector = _interopRequireDefault(require("../../../common/components/CollectionSelector"));

  var _layoutDataItemDefaultConfigurations = require("../../config/constants/layoutDataItemDefaultConfigurations");

  var _layoutDataItemTypes = require("../../config/constants/layoutDataItemTypes");

  var _selectSegmentsExperienceId = _interopRequireDefault(require("../../selectors/selectSegmentsExperienceId"));

  var _InfoItemService = _interopRequireDefault(require("../../services/InfoItemService"));

  var _index2 = require("../../store/index");

  var _updateItemConfig = _interopRequireDefault(require("../../thunks/updateItemConfig"));

  var _useId = require("../../utils/useId");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var LAYOUT_OPTIONS = [{
    label: Liferay.Language.get('full-width'),
    value: '1'
  }, {
    label: Liferay.Util.sub(Liferay.Language.get('x-columns'), 2),
    value: '2'
  }, {
    label: Liferay.Util.sub(Liferay.Language.get('x-columns'), 3),
    value: '3'
  }, {
    label: Liferay.Util.sub(Liferay.Language.get('x-columns'), 4),
    value: '4'
  }, {
    label: Liferay.Util.sub(Liferay.Language.get('x-columns'), 5),
    value: '5'
  }, {
    label: Liferay.Util.sub(Liferay.Language.get('x-columns'), 6),
    value: '6'
  }];

  function collectionIsMapped(collectionConfig) {
    return collectionConfig.collection;
  }

  var CollectionConfigurationPanel = function CollectionConfigurationPanel(_ref) {
    var item = _ref.item;
    var collectionLayoutId = (0, _useId.useId)();
    var collectionNumberOfItemsId = (0, _useId.useId)();
    var dispatch = (0, _index2.useDispatch)();
    var listStyleId = (0, _useId.useId)();
    var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId["default"]);

    var collectionConfig = _objectSpread({}, _layoutDataItemDefaultConfigurations.LAYOUT_DATA_ITEM_DEFAULT_CONFIGURATIONS[_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection], {}, item.config);

    var handleConfigurationChanged = function handleConfigurationChanged(itemConfig) {
      dispatch((0, _updateItemConfig["default"])({
        itemConfig: itemConfig,
        itemId: item.itemId,
        segmentsExperienceId: segmentsExperienceId
      }));
    };

    var _useState = (0, _react.useState)([]),
        _useState2 = _slicedToArray(_useState, 2),
        availableListRenderers = _useState2[0],
        setAvailableListRenderers = _useState2[1];

    var collectionItemType = collectionConfig.collection ? collectionConfig.collection.itemType : null;
    (0, _react.useEffect)(function () {
      if (collectionItemType) {
        _InfoItemService["default"].getAvailableListRenderers({
          className: collectionItemType
        }).then(function (response) {
          setAvailableListRenderers(response);
        })["catch"](function () {
          setAvailableListRenderers([]);
        });
      }
    }, [collectionItemType]);
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_form["default"].Group, {
      small: true
    }, _react["default"].createElement(_CollectionSelector["default"], {
      collectionTitle: collectionConfig.collection.title,
      itemSelectorURL: _index.config.collectionSelectorURL,
      label: Liferay.Language.get('collection'),
      onCollectionSelect: function onCollectionSelect(collection) {
        return handleConfigurationChanged({
          collection: collection
        });
      }
    })), collectionIsMapped(item.config) && _react["default"].createElement(_react["default"].Fragment, null, availableListRenderers.length > 0 && _react["default"].createElement(_form["default"].Group, {
      small: true
    }, _react["default"].createElement("label", {
      htmlFor: listStyleId
    }, Liferay.Language.get('list-style')), _react["default"].createElement(_form.ClaySelectWithOption, {
      "aria-label": Liferay.Language.get('list-style'),
      id: listStyleId,
      onChange: function onChange(_ref2) {
        var value = _ref2.target.value;
        return handleConfigurationChanged({
          listStyle: value
        });
      },
      options: availableListRenderers,
      value: item.config.listStyle
    })), _react["default"].createElement(_form["default"].Group, {
      small: true
    }, _react["default"].createElement("label", {
      htmlFor: collectionLayoutId
    }, Liferay.Language.get('layout')), _react["default"].createElement(_form.ClaySelectWithOption, {
      "aria-label": Liferay.Language.get('layout'),
      id: collectionLayoutId,
      onChange: function onChange(_ref3) {
        var value = _ref3.target.value;
        return handleConfigurationChanged({
          numberOfColumns: value
        });
      },
      options: LAYOUT_OPTIONS,
      value: item.config.numberOfColumns
    })), _react["default"].createElement(_form["default"].Group, {
      small: true
    }, _react["default"].createElement("label", {
      htmlFor: collectionNumberOfItemsId
    }, Liferay.Language.get('max-number-of-items')), _react["default"].createElement(_form.ClayInput, {
      id: collectionNumberOfItemsId,
      min: 1,
      onChange: function onChange(_ref4) {
        var value = _ref4.target.value;
        return handleConfigurationChanged({
          numberOfItems: value
        });
      },
      type: "number",
      value: collectionConfig.numberOfItems
    }))));
  };

  exports.CollectionConfigurationPanel = CollectionConfigurationPanel;
  //# sourceMappingURL=CollectionConfigurationPanel.js.map
});
//# sourceMappingURL=CollectionConfigurationPanel.js.map