Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/Topper", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../prop-types/index', '../actions/index', '../config/constants/layoutDataItemTypes', '../config/index', '../selectors/selectCanUpdate', '../store/index', '../thunks/deleteItem', '../thunks/moveItem', '../utils/useDragAndDrop', './Controls', './layout-data-items/getLabelName', './layout-data-items/hasDropZoneChild'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = _default;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _index = require("../../prop-types/index");

  var _index2 = require("../actions/index");

  var _layoutDataItemTypes = require("../config/constants/layoutDataItemTypes");

  var _index3 = require("../config/index");

  var _selectCanUpdate = _interopRequireDefault(require("../selectors/selectCanUpdate"));

  var _index4 = require("../store/index");

  var _deleteItem = _interopRequireDefault(require("../thunks/deleteItem"));

  var _moveItem = _interopRequireDefault(require("../thunks/moveItem"));

  var _useDragAndDrop = require("../utils/useDragAndDrop");

  var _Controls = require("./Controls");

  var _getLabelName = _interopRequireDefault(require("./layout-data-items/getLabelName"));

  var _hasDropZoneChild = _interopRequireDefault(require("./layout-data-items/hasDropZoneChild"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }return target;
    };return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
      }
    }return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
    }return target;
  }

  var TOPPER_BAR_HEIGHT = 24;

  var itemIsMappedCollection = function itemIsMappedCollection(item) {
    return item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection && 'collection' in item.config;
  };

  var TopperListItem = _react["default"].forwardRef(function (_ref, ref) {
    var children = _ref.children,
        className = _ref.className,
        expand = _ref.expand,
        props = _objectWithoutProperties(_ref, ["children", "className", "expand"]);

    return _react["default"].createElement("li", _extends({}, props, {
      className: (0, _classnames["default"])('page-editor__topper__item', 'tbar-item', {
        'tbar-item-expand': expand
      }, className),
      ref: ref
    }), children);
  });

  TopperListItem.displayName = 'TopperListItem';
  TopperListItem.propTypes = {
    expand: _propTypes["default"].bool
  };

  function _default(_ref2) {
    var children = _ref2.children,
        props = _objectWithoutProperties(_ref2, ["children"]);

    var canUpdate = (0, _index4.useSelector)(_selectCanUpdate["default"]);
    return canUpdate ? _react["default"].createElement(Topper, props, children) : children;
  }

  function Topper(_ref3) {
    var children = _ref3.children,
        item = _ref3.item,
        itemElement = _ref3.itemElement,
        layoutData = _ref3.layoutData;
    var dispatch = (0, _index4.useDispatch)();
    var store = (0, _index4.useSelector)(function (state) {
      return state;
    });
    var activeItemId = (0, _Controls.useActiveItemId)();
    var hoveredItemId = (0, _Controls.useHoveredItemId)();
    var hoverItem = (0, _Controls.useHoverItem)();
    var isHovered = (0, _Controls.useIsHovered)();
    var isActive = (0, _Controls.useIsActive)();
    var selectItem = (0, _Controls.useSelectItem)();

    var _useDropTarget = (0, _useDragAndDrop.useDropTarget)(item, layoutData),
        canDropOverTarget = _useDropTarget.canDropOverTarget,
        isOverTarget = _useDropTarget.isOverTarget,
        sourceItem = _useDropTarget.sourceItem,
        targetPosition = _useDropTarget.targetPosition,
        targetRef = _useDropTarget.targetRef;

    var _useDragItem = (0, _useDragAndDrop.useDragItem)(item, function (parentItemId, position) {
      return dispatch((0, _moveItem["default"])({
        itemId: item.itemId,
        parentItemId: parentItemId,
        position: position,
        store: store
      }));
    }),
        handlerRef = _useDragItem.handlerRef,
        isDraggingSource = _useDragItem.isDraggingSource;

    var itemIsRemovable = (0, _react.useMemo)(function () {
      return isRemovable(item, layoutData);
    }, [item, layoutData]);
    var commentsPanelId = _index3.config.sidebarPanels.comments.sidebarPanelId;
    var fragmentEntryLinks = store.fragmentEntryLinks;

    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        isInset = _useState2[0],
        setIsInset = _useState2[1];

    var _useState3 = (0, _react.useState)(0),
        _useState4 = _slicedToArray(_useState3, 2),
        windowScrollPosition = _useState4[0],
        setWindowScrollPosition = _useState4[1];

    (0, _react.useEffect)(function () {
      var handleWindowScroll = function handleWindowScroll() {
        setWindowScrollPosition(window.scrollY);
      };

      window.addEventListener('scroll', handleWindowScroll);
      return function () {
        window.removeEventListener('scroll', handleWindowScroll);
      };
    }, []);
    (0, _react.useEffect)(function () {
      if (itemElement) {
        var itemTop = itemElement.getBoundingClientRect().top - TOPPER_BAR_HEIGHT;
        var controlMenuContainerHeight = document.querySelector('.control-menu-container').offsetHeight;

        if (itemTop < controlMenuContainerHeight) {
          setIsInset(true);
        } else {
          setIsInset(false);
        }
      }
    }, [itemElement, layoutData, windowScrollPosition]);
    var dataAdvice = isOverTarget && !canDropOverTarget ? Liferay.Util.sub(Liferay.Language.get('a-x-cannot-be-dropped-inside-a-x'), [(0, _getLabelName["default"])(sourceItem, fragmentEntryLinks), (0, _getLabelName["default"])(item, fragmentEntryLinks)]) : null;
    return _react["default"].createElement("div", {
      className: (0, _classnames["default"])('page-editor__topper', {
        active: isActive(item.itemId),
        'drag-over-bottom': isOverTarget && targetPosition === _useDragAndDrop.TARGET_POSITION.BOTTOM,
        'drag-over-middle': isOverTarget && targetPosition === _useDragAndDrop.TARGET_POSITION.MIDDLE,
        'drag-over-top': isOverTarget && targetPosition === _useDragAndDrop.TARGET_POSITION.TOP,
        dragged: isDraggingSource,
        hovered: isHovered(item.itemId) || function fragmentShouldBeHovered() {
          var _ref4 = activeItemId ? activeItemId.split('-') : '',
              _ref5 = _slicedToArray(_ref4, 1),
              activeItemfragmentEntryLinkId = _ref5[0];

          var _ref6 = hoveredItemId ? hoveredItemId.split('-') : '',
              _ref7 = _slicedToArray(_ref6, 1),
              hoveredItemfragmentEntryLinkId = _ref7[0];

          var childIsActive = Number(activeItemfragmentEntryLinkId) === item.config.fragmentEntryLinkId;
          var childIsHovered = Number(hoveredItemfragmentEntryLinkId) === item.config.fragmentEntryLinkId;
          return item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment && (isHovered(item.itemId) || childIsActive && childIsHovered);
        }(),
        'not-droppable': !!dataAdvice,
        'page-editor__topper--mapped': itemIsMappedCollection(item)
      }),
      onClick: function onClick(event) {
        event.stopPropagation();

        if (isDraggingSource) {
          return;
        }

        selectItem(item.itemId);
      },
      onMouseLeave: function onMouseLeave(event) {
        event.stopPropagation();

        if (isDraggingSource) {
          return;
        }

        if (isHovered(item.itemId)) {
          hoverItem(null);
        }
      },
      onMouseOver: function onMouseOver(event) {
        event.stopPropagation();

        if (isDraggingSource) {
          return;
        }

        hoverItem(item.itemId);
      },
      ref: handlerRef
    }, _react["default"].createElement("div", {
      className: (0, _classnames["default"])('page-editor__topper__bar', 'tbar', {
        'page-editor__topper__bar--inset': isInset,
        'page-editor__topper__bar--mapped': itemIsMappedCollection(item)
      })
    }, _react["default"].createElement("ul", {
      className: "tbar-nav"
    }, _react["default"].createElement(TopperListItem, {
      className: "page-editor__topper__drag-handler"
    }, _react["default"].createElement(_icon["default"], {
      className: "page-editor__topper__drag-icon page-editor__topper__icon",
      symbol: "drag"
    })), _react["default"].createElement(TopperListItem, {
      className: "page-editor__topper__title",
      expand: true
    }, (0, _getLabelName["default"])(item, fragmentEntryLinks) || Liferay.Language.get('element')), item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment && _react["default"].createElement(TopperListItem, null, _react["default"].createElement(_button["default"], {
      displayType: "unstyled",
      small: true,
      title: Liferay.Language.get('comments')
    }, _react["default"].createElement(_icon["default"], {
      className: "page-editor__topper__icon",
      onClick: function onClick() {
        dispatch((0, _index2.switchSidebarPanel)({
          sidebarOpen: true,
          sidebarPanelId: commentsPanelId
        }));
      },
      symbol: "comments"
    }))), itemIsRemovable && _react["default"].createElement(TopperListItem, null, _react["default"].createElement(_button["default"], {
      displayType: "unstyled",
      onClick: function onClick(event) {
        event.stopPropagation();
        dispatch((0, _deleteItem["default"])({
          itemId: item.itemId,
          store: store
        }));
      },
      small: true,
      title: Liferay.Language.get('remove')
    }, _react["default"].createElement(_icon["default"], {
      className: "page-editor__topper__icon",
      symbol: "times-circle"
    }))))), _react["default"].createElement("div", {
      className: "page-editor__topper__content",
      ref: targetRef
    }, dataAdvice ? _react["default"].cloneElement(children, {
      data: {
        'data-advice': dataAdvice
      }
    }) : children));
  }

  function isRemovable(item, layoutData) {
    if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone || item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column) {
      return false;
    }

    return !(0, _hasDropZoneChild["default"])(item, layoutData);
  }
  //# sourceMappingURL=Topper.js.map
});
//# sourceMappingURL=Topper.js.map