Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/NetworkStatusBar", ['module', 'exports', 'require', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$react', '../config/constants/serviceNetworkStatusTypes'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _frontendJsWeb = require("frontend-js-web");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _serviceNetworkStatusTypes = require("../config/constants/serviceNetworkStatusTypes");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var getStatus = function getStatus(isOnline, status, lastSaveDate) {
    if (!isOnline) {
      return "".concat(Liferay.Language.get('trying-to-reconnect'), "...");
    } else if (status === _serviceNetworkStatusTypes.SERVICE_NETWORK_STATUS_TYPES.savingDraft) {
      return Liferay.Language.get('saving-changes');
    } else if (lastSaveDate) {
      return lastSaveDate;
    }

    return null;
  };

  var parseDate = function parseDate(date) {
    if (!date) {
      return null;
    }

    var lastSaveDateText = Liferay.Language.get('changes-saved');
    return lastSaveDateText.replace('{0}', date.toLocaleTimeString(Liferay.ThemeDisplay.getBCP47LanguageId()));
  };

  var NetworkStatusBar = function NetworkStatusBar(_ref) {
    var error = _ref.error,
        lastFetch = _ref.lastFetch,
        status = _ref.status;

    var _useState = (0, _react.useState)(true),
        _useState2 = _slicedToArray(_useState, 2),
        isOnline = _useState2[0],
        setIsOnline = _useState2[1];

    var _useState3 = (0, _react.useState)(parseDate(lastFetch)),
        _useState4 = _slicedToArray(_useState3, 2),
        lastSaveDate = _useState4[0],
        setLastSaveDate = _useState4[1];

    (0, _react.useEffect)(function () {
      setLastSaveDate(parseDate(lastFetch));
    }, [lastFetch]);
    (0, _react.useEffect)(function () {
      if (status === _serviceNetworkStatusTypes.SERVICE_NETWORK_STATUS_TYPES.error) {
        (0, _frontendJsWeb.openToast)({
          message: error,
          title: Liferay.Language.get('error'),
          type: 'danger'
        });
      }
    }, [error, status]);
    (0, _frontendJsReactWeb.useEventListener)('online', function () {
      return setIsOnline(true);
    }, true, window);
    (0, _frontendJsReactWeb.useEventListener)('offline', function () {
      return setIsOnline(false);
    }, true, window);
    var statusText = getStatus(isOnline, status, lastSaveDate);

    if (!statusText) {
      return null;
    }

    return _react["default"].createElement("li", {
      className: "d-inline nav-item text-truncate"
    }, _react["default"].createElement("span", {
      className: "my-0 navbar-text",
      "data-title": statusText
    }, statusText));
  };

  var _default = NetworkStatusBar;
  exports["default"] = _default;
  //# sourceMappingURL=NetworkStatusBar.js.map
});
//# sourceMappingURL=NetworkStatusBar.js.map