Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/MasterLayout", ['module', 'exports', 'require', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-metal-web$metal-dom', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../prop-types/index', '../config/constants/layoutDataItemTypes', '../config/index', '../store/index', './CollectionItemContext', './Controls', './Layout', './UnsafeHTML', './fragment-content/getAllEditables', './fragment-content/resolveEditableValue', './layout-data-items/index'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = MasterPage;

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _frontendJsWeb = require("frontend-js-web");

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _index = require("../../prop-types/index");

  var _layoutDataItemTypes = require("../config/constants/layoutDataItemTypes");

  var _index2 = require("../config/index");

  var _index3 = require("../store/index");

  var _CollectionItemContext = require("./CollectionItemContext");

  var _Controls = require("./Controls");

  var _Layout = _interopRequireDefault(require("./Layout"));

  var _UnsafeHTML = _interopRequireDefault(require("./UnsafeHTML"));

  var _getAllEditables = _interopRequireDefault(require("./fragment-content/getAllEditables"));

  var _resolveEditableValue = _interopRequireDefault(require("./fragment-content/resolveEditableValue"));

  var _index4 = require("./layout-data-items/index");

  var _LAYOUT_DATA_ITEMS;

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var LAYOUT_DATA_ITEMS = (_LAYOUT_DATA_ITEMS = {}, _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, _index4.Collection), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem, CollectionItem), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column, _index4.Column), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, _index4.Container), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, DropZoneContainer), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment, Fragment), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragmentDropZone, Root), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.root, Root), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _index4.Row), _LAYOUT_DATA_ITEMS);

  function MasterPage() {
    var fragmentEntryLinks = (0, _index3.useSelector)(function (state) {
      return state.fragmentEntryLinks;
    });
    var masterLayoutData = (0, _index3.useSelector)(function (state) {
      return state.masterLayoutData;
    });
    var mainItem = masterLayoutData.items[masterLayoutData.rootItems.main];
    return _react["default"].createElement("div", {
      className: "master-page"
    }, _react["default"].createElement(MasterLayoutDataItem, {
      fragmentEntryLinks: fragmentEntryLinks,
      item: mainItem,
      layoutData: masterLayoutData
    }));
  }

  function MasterLayoutDataItem(_ref) {
    var fragmentEntryLinks = _ref.fragmentEntryLinks,
        item = _ref.item,
        layoutData = _ref.layoutData;
    var Component = LAYOUT_DATA_ITEMS[item.type];

    if (!Component) {
      return null;
    }

    return _react["default"].createElement(Component, {
      fragmentEntryLinks: fragmentEntryLinks,
      item: item,
      layoutData: layoutData
    }, item.children.map(function (childId) {
      return _react["default"].createElement(MasterLayoutDataItem, {
        fragmentEntryLinks: fragmentEntryLinks,
        item: layoutData.items[childId],
        key: childId,
        layoutData: layoutData
      });
    }));
  }

  function DropZoneContainer() {
    var mainItemId = (0, _index3.useSelector)(function (state) {
      return state.layoutData.rootItems.main;
    });
    return _react["default"].createElement(_Layout["default"], {
      mainItemId: mainItemId,
      withinMasterPage: true
    });
  }

  function Root(_ref2) {
    var children = _ref2.children;
    return _react["default"].createElement("div", null, children);
  }

  function CollectionItem(_ref3) {
    var children = _ref3.children;
    return _react["default"].createElement("div", null, children);
  }

  var FragmentContent = _react["default"].memo(function FragmentContent(_ref4) {
    var defaultContent = _ref4.content,
        editableValues = _ref4.editableValues,
        languageId = _ref4.languageId;
    var ref = (0, _react.useRef)(null);
    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

    var _useState = (0, _react.useState)(defaultContent),
        _useState2 = _slicedToArray(_useState, 2),
        content = _useState2[0],
        setContent = _useState2[1];

    var selectItem = (0, _Controls.useSelectItem)();
    var getFieldValue = (0, _CollectionItemContext.useGetFieldValue)();
    (0, _react.useEffect)(function () {
      var element = ref.current;

      if (!element) {
        return;
      }

      var handler = function handler(event) {
        var element = event.target;

        if ((0, _metalDom.closest)(element, '[href]')) {
          event.preventDefault();
        }

        if (!(0, _metalDom.closest)(event.target, '.page-editor')) {
          selectItem(null);
        }
      };

      element.addEventListener('click', handler);
      return function () {
        element.removeEventListener('click', handler);
      };
    });
    (0, _react.useEffect)(function () {
      var element = document.createElement('div');
      element.innerHTML = content;
      var updateContent = (0, _frontendJsWeb.debounce)(function () {
        if (isMounted() && element) {
          setContent(element.innerHTML);
        }
      }, 50);
      (0, _getAllEditables["default"])(element).forEach(function (editable) {
        (0, _resolveEditableValue["default"])(editableValues, editable.editableId, editable.editableValueNamespace, languageId, null, getFieldValue).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 2),
              value = _ref6[0],
              editableConfig = _ref6[1];

          editable.processor.render(editable.element, value, editableConfig);
        });
      });
      updateContent();
      return function () {
        element = null;
      };
    }, [defaultContent, content, isMounted, editableValues, languageId, getFieldValue]);
    var fragmentEntryLinks = (0, _index3.useSelector)(function (state) {
      return state.fragmentEntryLinks;
    });
    var masterLayoutData = (0, _index3.useSelector)(function (state) {
      return state.masterLayoutData;
    });
    var getPortals = (0, _react.useCallback)(function (element) {
      return Array.from(element.querySelectorAll('lfr-drop-zone')).map(function (dropZoneElement) {
        var mainItemId = dropZoneElement.getAttribute('uuid') || '';

        var Component = function Component() {
          return mainItemId ? _react["default"].createElement(MasterLayoutDataItem, {
            fragmentEntryLinks: fragmentEntryLinks,
            item: masterLayoutData.items[mainItemId],
            layoutData: masterLayoutData
          }) : null;
        };

        Component.displayName = "DropZone(".concat(mainItemId, ")");
        return {
          Component: Component,
          element: dropZoneElement
        };
      });
    }, [fragmentEntryLinks, masterLayoutData]);
    return _react["default"].createElement(_UnsafeHTML["default"], {
      className: "page-editor__fragment-content page-editor__fragment-content--master",
      contentRef: ref,
      getPortals: getPortals,
      markup: content
    });
  });

  function Fragment(_ref7) {
    var fragmentEntryLinks = _ref7.fragmentEntryLinks,
        item = _ref7.item;
    var fragmentEntryLink = fragmentEntryLinks[item.config.fragmentEntryLinkId];
    var languageId = (0, _index3.useSelector)(function (state) {
      return state.languageId;
    });
    return _react["default"].createElement(FragmentContent, {
      content: fragmentEntryLink.content,
      editableValues: fragmentEntryLink.editableValues,
      languageId: languageId || _index2.config.defaultLanguageId
    });
  }
  //# sourceMappingURL=MasterLayout.js.map
});
//# sourceMappingURL=MasterLayout.js.map